/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.util.Try;

public class DFunction {
    private static final Pattern PAT_SELECT_FROM = Pattern.compile("SELECT(.*\\W)FROM(.*)", 2);
    private static final String DFUNCTIONS_WHERE = "\\s*\\(\\s*['\"](.*)['\"]\\,\\s*['\"](.*)['\"]\\,\\s*['\"](.*)['\"]\\s*\\)";
    private static final String DFUNCTIONS_WHERE_DYNAMIC = "\\s*\\(\\s*['\"](.*)['\"]\\,\\s*['\"](.*)['\"]\\,(.*)\\)";
    private static final String DFUNCTIONS_NO_WHERE = "\\s*\\(\\s*['\"](.*)['\"]\\,\\s*['\"](.*)['\"]\\s*\\)";
    private static final List<String> DFUNCTION_LIST = List.of("COUNT", "MAX", "MIN", "SUM", "AVG", "LAST", "FIRST", "LOOKUP");
    private Connection conn;
    private final String sql;

    public DFunction(Connection _conn, String _sql) {
        this.conn = _conn;
        this.sql = _sql;
    }

    /*
     * WARNING - void declaration
     */
    private String convertDFunctions() {
        String sqlOut = this.sql;
        boolean hasFrom = this.sql.toUpperCase().contains(" FROM ");
        String init = hasFrom ? " (SELECT " : "";
        String end = hasFrom ? " ) " : "";
        for (String f : DFUNCTION_LIST) {
            String dfun = "D" + f;
            if ("lookup".equalsIgnoreCase(f)) {
                f = " ";
            }
            sqlOut = Pattern.compile(dfun + DFUNCTIONS_WHERE, 2).matcher(sqlOut).replaceAll(init + f + "($1) FROM $2 WHERE $3" + end);
            sqlOut = Pattern.compile(dfun + DFUNCTIONS_NO_WHERE, 2).matcher(sqlOut).replaceAll(init + f + "($1) FROM $2" + end);
            Pattern patDfd = Pattern.compile(dfun + DFUNCTIONS_WHERE_DYNAMIC, 2);
            Matcher mtc = patDfd.matcher(sqlOut);
            while (mtc.find()) {
                boolean sqlConcat;
                StringBuilder sb = new StringBuilder();
                String g3 = mtc.group(3);
                String tableN = mtc.group(2).trim();
                String alias = tableN.startsWith("[") && tableN.endsWith("]") ? "[" + DFunction.unpad(tableN) + "_DALIAS]" : tableN + "_DALIAS";
                String tn = tableN.startsWith("[") && tableN.endsWith("]") ? DFunction.unpad(tableN) : tableN;
                sb.append(init).append(f).append("(").append(mtc.group(1)).append(") FROM ").append(tableN).append(" AS ").append(alias).append(" WHERE ");
                boolean accessConcat = g3.indexOf(38) > 0;
                boolean bl = sqlConcat = g3.indexOf("||") > 0;
                if (accessConcat || sqlConcat) {
                    String[] pts;
                    String concat = accessConcat ? "&" : Pattern.quote("||");
                    for (String string : pts = g3.split(concat, -1)) {
                        void var22_26;
                        if (DFunction.isQuoted(string)) {
                            String string2 = string.trim();
                            sb.append(DFunction.unpad(string2));
                            continue;
                        }
                        String string3 = string + " ";
                        try {
                            for (String cln : this.getColumnNames(tn.toUpperCase())) {
                                String pref;
                                Pattern patOppn = Pattern.compile("(\\W)(" + cln + ")(\\W)", 2);
                                Matcher mtcop = patOppn.matcher((CharSequence)var22_26);
                                if (!mtcop.find() || ".".equals(pref = mtcop.group(1)) || "[".equals(pref) && mtcop.start(1) > 0 && var22_26.charAt(mtcop.start(1) - 1) == '.') continue;
                                String string4 = var22_26.replaceAll("(\\W)((?i)" + cln + ")(\\W)", "[".equals(pref) ? this.resolveAmbiguosTableName(cln) + ".$1$2$3" : "$1" + this.resolveAmbiguosTableName(cln) + ".$2$3");
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        sb.append((String)var22_26);
                    }
                }
                sb.append(end);
                sqlOut = sqlOut.replaceFirst(DFUNCTIONS_WHERE_DYNAMIC.replaceFirst("_", dfun), sb.toString());
                mtc = patDfd.matcher(sqlOut);
            }
        }
        return sqlOut;
    }

    private String resolveAmbiguosTableName(String _identifier) {
        return Try.withResources(this.conn::createStatement, st -> {
            String sqlOut = this.sql.replaceAll("[\\r\\n]+", " ");
            String f4t = SQLConverter.convertSQL(sqlOut = PAT_SELECT_FROM.matcher(sqlOut).replaceFirst("SELECT " + _identifier + " FROM $2")).getSql();
            ResultSetMetaData rsmd = st.executeQuery(f4t).getMetaData();
            String tableN = rsmd.getTableName(1);
            return tableN == null || tableN.isBlank() ? _identifier : tableN;
        }).orElse(_identifier);
    }

    private List<String> getColumnNames(String tableName) throws SQLException {
        ArrayList<String> ar = new ArrayList<String>();
        if (this.conn == null) {
            UcanaccessConnection conu = UcanaccessConnection.getCtxConnection();
            if (conu == null) {
                return ar;
            }
            this.conn = conu.getHSQLDBConnection();
        }
        DatabaseMetaData dbmd = this.conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, null, tableName, null);
        while (rs.next()) {
            ar.add(rs.getString("COLUMN_NAME"));
        }
        return ar;
    }

    private static boolean isQuoted(String g3) {
        return (g3 = g3.trim()).startsWith("'") && g3.endsWith("'") && g3.substring(1, g3.length() - 1).indexOf(39) < 0 || g3.startsWith("\"") && g3.endsWith("\"") && g3.substring(1, g3.length() - 1).indexOf(34) < 0;
    }

    private static String unpad(String tkn) {
        return tkn.substring(1, tkn.length() - 1);
    }

    public String toSQL() {
        return this.convertDFunctions();
    }

    public static String convertDFunctions(String sql, Connection conu) {
        return new DFunction(conu, sql).toSQL();
    }
}

