/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorUtil {
    public static final String SIMPLE_NAME = ExecutorUtil.class.getSimpleName();
    private static final AtomicInteger threadNum = new AtomicInteger(1);
    private static final ExecutorService executor = ExecutorUtil.init();

    private ExecutorUtil() {
    }

    private static ExecutorService init() {
        return Executors.newCachedThreadPool(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName(SIMPLE_NAME + " thread " + threadNum.getAndIncrement());
            return thread;
        });
    }

    public static ExecutorService getExecutor() {
        return executor;
    }
}

