/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.xml;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hop.core.xml.XMlHandlerCacheEntry;

public class XmlHandlerCache {
    private static XmlHandlerCache instance;
    Map<XMlHandlerCacheEntry, Integer> cache = Collections.synchronizedMap(new WeakHashMap());
    private AtomicInteger cacheHits = new AtomicInteger();

    private XmlHandlerCache() {
    }

    public static synchronized XmlHandlerCache getInstance() {
        if (instance == null) {
            instance = new XmlHandlerCache();
        }
        return instance;
    }

    public void storeCache(XMlHandlerCacheEntry entry, int lastChildNr) {
        this.cache.put(entry, lastChildNr);
    }

    public int getLastChildNr(XMlHandlerCacheEntry entry) {
        Integer lastChildNr = this.cache.get(entry);
        if (lastChildNr != null) {
            this.cacheHits.incrementAndGet();
            return lastChildNr;
        }
        return -1;
    }

    public int getCacheHits() {
        return this.cacheHits.get();
    }

    public void setCacheHits(int cacheHits) {
        this.cacheHits.set(cacheHits);
    }

    public void clear() {
        this.cache.clear();
    }
}

