/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class ContainerRetryContextPBImpl
extends ContainerRetryContext {
    private YarnProtos.ContainerRetryContextProto proto = YarnProtos.ContainerRetryContextProto.getDefaultInstance();
    private YarnProtos.ContainerRetryContextProto.Builder builder = null;
    private boolean viaProto = false;
    private Set<Integer> errorCodes = null;

    public ContainerRetryContextPBImpl() {
        this.builder = YarnProtos.ContainerRetryContextProto.newBuilder();
    }

    public ContainerRetryContextPBImpl(YarnProtos.ContainerRetryContextProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ContainerRetryContextProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ContainerRetryContextPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.errorCodes != null) {
            this.builder.clearErrorCodes();
            this.builder.addAllErrorCodes(this.errorCodes);
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerRetryContextProto.newBuilder((YarnProtos.ContainerRetryContextProto)this.proto);
        }
        this.viaProto = false;
    }

    public ContainerRetryPolicy getRetryPolicy() {
        YarnProtos.ContainerRetryContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasRetryPolicy()) {
            return ContainerRetryPolicy.NEVER_RETRY;
        }
        return this.convertFromProtoFormat(p.getRetryPolicy());
    }

    public void setRetryPolicy(ContainerRetryPolicy containerRetryPolicy) {
        this.maybeInitBuilder();
        if (containerRetryPolicy == null) {
            this.builder.clearRetryPolicy();
            return;
        }
        this.builder.setRetryPolicy(this.convertToProtoFormat(containerRetryPolicy));
    }

    private void initErrorCodes() {
        if (this.errorCodes != null) {
            return;
        }
        YarnProtos.ContainerRetryContextProto p = this.viaProto ? this.proto : this.builder;
        this.errorCodes = new HashSet<Integer>();
        this.errorCodes.addAll(p.getErrorCodesList());
    }

    public Set<Integer> getErrorCodes() {
        this.initErrorCodes();
        return this.errorCodes;
    }

    public void setErrorCodes(Set<Integer> errCodes) {
        this.maybeInitBuilder();
        if (errCodes == null || errCodes.isEmpty()) {
            this.builder.clearErrorCodes();
        }
        this.errorCodes = errCodes;
    }

    public int getMaxRetries() {
        YarnProtos.ContainerRetryContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasMaxRetries()) {
            return 0;
        }
        return p.getMaxRetries();
    }

    public void setMaxRetries(int maxRetries) {
        this.maybeInitBuilder();
        this.builder.setMaxRetries(maxRetries);
    }

    public int getRetryInterval() {
        YarnProtos.ContainerRetryContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasRetryInterval()) {
            return 0;
        }
        return p.getRetryInterval();
    }

    public void setRetryInterval(int retryInterval) {
        this.maybeInitBuilder();
        this.builder.setRetryInterval(retryInterval);
    }

    public long getFailuresValidityInterval() {
        YarnProtos.ContainerRetryContextProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasFailuresValidityInterval()) {
            return -1L;
        }
        return p.getFailuresValidityInterval();
    }

    public void setFailuresValidityInterval(long failuresValidityInterval) {
        this.maybeInitBuilder();
        this.builder.setFailuresValidityInterval(failuresValidityInterval);
    }

    private YarnProtos.ContainerRetryPolicyProto convertToProtoFormat(ContainerRetryPolicy containerRetryPolicy) {
        return ProtoUtils.convertToProtoFormat(containerRetryPolicy);
    }

    private ContainerRetryPolicy convertFromProtoFormat(YarnProtos.ContainerRetryPolicyProto containerRetryPolicyProto) {
        return ProtoUtils.convertFromProtoFormat(containerRetryPolicyProto);
    }
}

