/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChat;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatData;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.LanguageModelChatModelName;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;

@Transform(id="LanguageModelChat", image="languagemodelchat.svg", name="i18n::BaseTransform.TypeLongDesc.LanguageModelChat", description="i18n::BaseTransform.TypeTooltipDesc.LanguageModelChat", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/languagemodelchat.html")
public class LanguageModelChatMeta
extends BaseTransformMeta<LanguageModelChat, LanguageModelChatData> {
    private static final Class<?> PKG = LanguageModelChatMeta.class;
    @HopMetadataProperty
    private String inputField = "input";
    @HopMetadataProperty
    private boolean inputChatJson = false;
    @HopMetadataProperty
    private boolean outputChatJson = false;
    @HopMetadataProperty
    private boolean mock = false;
    @HopMetadataProperty
    private String outputFieldNamePrefix = "llm_";
    @HopMetadataProperty
    private String mockOutputValue = "";
    @HopMetadataProperty
    private String identifierValue = "";
    @HopMetadataProperty
    private String modelType = ModelType.OPEN_AI.code();
    @HopMetadataProperty
    private int parallelism = 1;
    @HopMetadataProperty
    private String openAiBaseUrl = "https://api.openai.com/v1";
    @HopMetadataProperty
    private String openAiApiKey = "OPENAI_API_KEY}";
    @HopMetadataProperty
    private String openAiOrganizationId;
    @HopMetadataProperty
    private String openAiModelName = LanguageModelChatModelName.OPENAI_GPT_4O.toString();
    @HopMetadataProperty
    private Double openAiTemperature = 0.7;
    @HopMetadataProperty
    private Double openAiTopP;
    @HopMetadataProperty
    private Integer openAiMaxTokens;
    @HopMetadataProperty
    private Double openAiPresencePenalty;
    @HopMetadataProperty
    private Double openAiFrequencyPenalty;
    @HopMetadataProperty
    private String openAiResponseFormat = "text";
    @HopMetadataProperty
    private Integer openAiSeed;
    @HopMetadataProperty
    private String openAiUser;
    @HopMetadataProperty
    private Integer openAiTimeout = 60;
    @HopMetadataProperty
    private Integer openAiMaxRetries = 3;
    @HopMetadataProperty
    private boolean openAiUseProxy = false;
    @HopMetadataProperty
    private String openAiProxyHost = "127.0.0.1";
    @HopMetadataProperty
    private Integer openAiProxyPort = 30000;
    @HopMetadataProperty
    private boolean openAiLogRequests = false;
    @HopMetadataProperty
    private boolean openAiLogResponses = false;
    @HopMetadataProperty
    private String huggingFaceAccessToken = "HF_ACCESS_TOKEN";
    @HopMetadataProperty
    private String huggingFaceModelId = LanguageModelChatModelName.HUGGING_FACE_LLAMA3_70B_INSTRUCT.toString();
    @HopMetadataProperty
    private Integer huggingFaceTimeout = 15;
    @HopMetadataProperty
    private Double huggingFaceTemperature;
    @HopMetadataProperty
    private Integer huggingFaceMaxNewTokens;
    @HopMetadataProperty
    private boolean huggingFaceReturnFullText = false;
    @HopMetadataProperty
    private boolean huggingFaceWaitForModel = true;
    @HopMetadataProperty
    private String mistralBaseUrl = "https://api.mistral.ai/v1";
    @HopMetadataProperty
    private String mistralApiKey = "MISTRAL_API_KEY";
    @HopMetadataProperty
    private String mistralModelName = LanguageModelChatModelName.MISTRAL_LARGE_LATEST.toString();
    @HopMetadataProperty
    private Double mistralTemperature;
    @HopMetadataProperty
    private Double mistralTopP;
    @HopMetadataProperty
    private Integer mistralMaxTokens;
    @HopMetadataProperty
    private boolean mistralSafePrompt = true;
    @HopMetadataProperty
    private Integer mistralRandomSeed;
    @HopMetadataProperty
    private String mistralResponseFormat;
    @HopMetadataProperty
    private Integer mistralTimeout = 60;
    @HopMetadataProperty
    private boolean mistralLogRequests = false;
    @HopMetadataProperty
    private boolean mistralLogResponses = false;
    @HopMetadataProperty
    private Integer mistralMaxRetries = 3;
    @HopMetadataProperty
    private String ollamaImageEndpoint;
    @HopMetadataProperty
    private String ollamaModelName = LanguageModelChatModelName.OLLAMA_PHI3_3_8B.toString();
    @HopMetadataProperty
    private Double ollamaTemperature;
    @HopMetadataProperty
    private Integer ollamaTopK;
    @HopMetadataProperty
    private Double ollamaTopP;
    @HopMetadataProperty
    private Double ollamaRepeatPenalty;
    @HopMetadataProperty
    private Integer ollamaSeed;
    @HopMetadataProperty
    private Integer ollamaNumPredict;
    @HopMetadataProperty
    private Integer ollamaNumCtx;
    @HopMetadataProperty
    private String ollamaFormat;
    @HopMetadataProperty
    private Integer ollamaTimeout = 60;
    @HopMetadataProperty
    private Integer ollamaMaxRetries = 3;
    @HopMetadataProperty
    private String anthropicBaseUrl = "https://api.anthropic.com/v1/";
    @HopMetadataProperty
    private String anthropicApiKey = "ANTHROPIC_API_KEY";
    @HopMetadataProperty
    private String anthropicVersion = "2023-06-01";
    @HopMetadataProperty
    private String anthropicModelName = LanguageModelChatModelName.ANTHROPIC_CLAUDE_3_OPUS_20240229.toString();
    @HopMetadataProperty
    private Double anthropicTemperature;
    @HopMetadataProperty
    private Double anthropicTopP;
    @HopMetadataProperty
    private Integer anthropicTopK;
    @HopMetadataProperty
    private Integer anthropicMaxTokens = 1024;
    @HopMetadataProperty
    private Integer anthropicTimeout = 15;
    @HopMetadataProperty
    private Integer anthropicMaxRetries = 3;
    @HopMetadataProperty
    private boolean anthropicLogRequests = false;
    @HopMetadataProperty
    private boolean anthropicLogResponses = false;

    public void setDefault() {
        this.inputField = "input";
        this.inputChatJson = false;
        this.outputChatJson = false;
        this.mock = false;
        this.outputFieldNamePrefix = "llm_";
        this.mockOutputValue = "";
        this.identifierValue = "";
        this.modelType = ModelType.OPEN_AI.code();
        this.parallelism = 1;
        this.openAiBaseUrl = "https://api.openai.com/v1";
        this.openAiApiKey = "OPENAI_API_KEY";
        this.openAiModelName = LanguageModelChatModelName.OPENAI_GPT_4O_MINI.toString();
        this.openAiResponseFormat = "text";
        this.openAiTemperature = 0.7;
        this.openAiTimeout = 60;
        this.openAiMaxRetries = 3;
        this.openAiUseProxy = false;
        this.openAiProxyHost = "127.0.0.1";
        this.openAiProxyPort = 30000;
        this.openAiLogRequests = false;
        this.openAiLogResponses = false;
        this.huggingFaceAccessToken = "HF_ACCESS_TOKEN";
        this.huggingFaceModelId = LanguageModelChatModelName.HUGGING_FACE_LLAMA3_70B_INSTRUCT.toString();
        this.huggingFaceTimeout = 15;
        this.huggingFaceReturnFullText = false;
        this.huggingFaceWaitForModel = true;
        this.mistralBaseUrl = "https://api.mistral.ai/v1";
        this.mistralApiKey = "MISTRAL_API_KEY";
        this.mistralModelName = LanguageModelChatModelName.MISTRAL_LARGE_LATEST.toString();
        this.mistralSafePrompt = true;
        this.mistralTimeout = 60;
        this.mistralLogRequests = false;
        this.mistralLogResponses = false;
        this.mistralMaxRetries = 3;
        this.ollamaImageEndpoint = "";
        this.ollamaModelName = LanguageModelChatModelName.OLLAMA_PHI3_3_8B.toString();
        this.ollamaTimeout = 60;
        this.ollamaMaxRetries = 3;
        this.anthropicBaseUrl = "https://api.anthropic.com/v1/";
        this.anthropicApiKey = "ANTHROPIC_API_KEY";
        this.anthropicVersion = "2023-06-01";
        this.anthropicModelName = LanguageModelChatModelName.ANTHROPIC_CLAUDE_3_HAIKU_20240307.toString();
        this.anthropicMaxTokens = 1024;
        this.anthropicTimeout = 15;
        this.anthropicMaxRetries = 3;
        this.anthropicLogRequests = false;
        this.anthropicLogResponses = false;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        this.valueMetaString(r, name, variables.resolve(this.outputFieldNamePrefix + "identifier"));
        this.valueMetaString(r, name, variables.resolve(this.outputFieldNamePrefix + "model_type"));
        this.valueMetaString(r, name, variables.resolve(this.outputFieldNamePrefix + "model_name"));
        this.valueMetaString(r, name, variables.resolve(this.outputFieldNamePrefix + "finish_reason"));
        this.valueMetaInteger(r, name, variables.resolve(this.outputFieldNamePrefix + "input_token_count"));
        this.valueMetaInteger(r, name, variables.resolve(this.outputFieldNamePrefix + "output_token_count"));
        this.valueMetaInteger(r, name, variables.resolve(this.outputFieldNamePrefix + "total_token_count"));
        this.valueMetaInteger(r, name, variables.resolve(this.outputFieldNamePrefix + "inference_time"));
        this.valueMetaString(r, name, variables.resolve(this.outputFieldNamePrefix + "output"));
    }

    private void valueMetaString(IRowMeta r, String name, String metaName) {
        ValueMetaString sText = new ValueMetaString(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    private void valueMetaBoolean(IRowMeta r, String name, String metaName) {
        ValueMetaBoolean sText = new ValueMetaBoolean(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    private void valueMetaInteger(IRowMeta r, String name, String metaName) {
        ValueMetaInteger sText = new ValueMetaInteger(metaName);
        sText.setOrigin(name);
        r.addValueMeta((IValueMeta)sText);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.inputField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.InputFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.InputFieldOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.outputFieldNamePrefix) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.OutputFieldNamePrefixMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.OutputFieldNamePrefixOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.modelType) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.ModelTypeMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.ModelTypeOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"LanguageModelChatMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    @Generated
    public String getInputField() {
        return this.inputField;
    }

    @Generated
    public boolean isInputChatJson() {
        return this.inputChatJson;
    }

    @Generated
    public boolean isOutputChatJson() {
        return this.outputChatJson;
    }

    @Generated
    public boolean isMock() {
        return this.mock;
    }

    @Generated
    public String getOutputFieldNamePrefix() {
        return this.outputFieldNamePrefix;
    }

    @Generated
    public String getMockOutputValue() {
        return this.mockOutputValue;
    }

    @Generated
    public String getIdentifierValue() {
        return this.identifierValue;
    }

    @Generated
    public String getModelType() {
        return this.modelType;
    }

    @Generated
    public int getParallelism() {
        return this.parallelism;
    }

    @Generated
    public String getOpenAiBaseUrl() {
        return this.openAiBaseUrl;
    }

    @Generated
    public String getOpenAiApiKey() {
        return this.openAiApiKey;
    }

    @Generated
    public String getOpenAiOrganizationId() {
        return this.openAiOrganizationId;
    }

    @Generated
    public String getOpenAiModelName() {
        return this.openAiModelName;
    }

    @Generated
    public Double getOpenAiTemperature() {
        return this.openAiTemperature;
    }

    @Generated
    public Double getOpenAiTopP() {
        return this.openAiTopP;
    }

    @Generated
    public Integer getOpenAiMaxTokens() {
        return this.openAiMaxTokens;
    }

    @Generated
    public Double getOpenAiPresencePenalty() {
        return this.openAiPresencePenalty;
    }

    @Generated
    public Double getOpenAiFrequencyPenalty() {
        return this.openAiFrequencyPenalty;
    }

    @Generated
    public String getOpenAiResponseFormat() {
        return this.openAiResponseFormat;
    }

    @Generated
    public Integer getOpenAiSeed() {
        return this.openAiSeed;
    }

    @Generated
    public String getOpenAiUser() {
        return this.openAiUser;
    }

    @Generated
    public Integer getOpenAiTimeout() {
        return this.openAiTimeout;
    }

    @Generated
    public Integer getOpenAiMaxRetries() {
        return this.openAiMaxRetries;
    }

    @Generated
    public boolean isOpenAiUseProxy() {
        return this.openAiUseProxy;
    }

    @Generated
    public String getOpenAiProxyHost() {
        return this.openAiProxyHost;
    }

    @Generated
    public Integer getOpenAiProxyPort() {
        return this.openAiProxyPort;
    }

    @Generated
    public boolean isOpenAiLogRequests() {
        return this.openAiLogRequests;
    }

    @Generated
    public boolean isOpenAiLogResponses() {
        return this.openAiLogResponses;
    }

    @Generated
    public String getHuggingFaceAccessToken() {
        return this.huggingFaceAccessToken;
    }

    @Generated
    public String getHuggingFaceModelId() {
        return this.huggingFaceModelId;
    }

    @Generated
    public Integer getHuggingFaceTimeout() {
        return this.huggingFaceTimeout;
    }

    @Generated
    public Double getHuggingFaceTemperature() {
        return this.huggingFaceTemperature;
    }

    @Generated
    public Integer getHuggingFaceMaxNewTokens() {
        return this.huggingFaceMaxNewTokens;
    }

    @Generated
    public boolean isHuggingFaceReturnFullText() {
        return this.huggingFaceReturnFullText;
    }

    @Generated
    public boolean isHuggingFaceWaitForModel() {
        return this.huggingFaceWaitForModel;
    }

    @Generated
    public String getMistralBaseUrl() {
        return this.mistralBaseUrl;
    }

    @Generated
    public String getMistralApiKey() {
        return this.mistralApiKey;
    }

    @Generated
    public String getMistralModelName() {
        return this.mistralModelName;
    }

    @Generated
    public Double getMistralTemperature() {
        return this.mistralTemperature;
    }

    @Generated
    public Double getMistralTopP() {
        return this.mistralTopP;
    }

    @Generated
    public Integer getMistralMaxTokens() {
        return this.mistralMaxTokens;
    }

    @Generated
    public boolean isMistralSafePrompt() {
        return this.mistralSafePrompt;
    }

    @Generated
    public Integer getMistralRandomSeed() {
        return this.mistralRandomSeed;
    }

    @Generated
    public String getMistralResponseFormat() {
        return this.mistralResponseFormat;
    }

    @Generated
    public Integer getMistralTimeout() {
        return this.mistralTimeout;
    }

    @Generated
    public boolean isMistralLogRequests() {
        return this.mistralLogRequests;
    }

    @Generated
    public boolean isMistralLogResponses() {
        return this.mistralLogResponses;
    }

    @Generated
    public Integer getMistralMaxRetries() {
        return this.mistralMaxRetries;
    }

    @Generated
    public String getOllamaImageEndpoint() {
        return this.ollamaImageEndpoint;
    }

    @Generated
    public String getOllamaModelName() {
        return this.ollamaModelName;
    }

    @Generated
    public Double getOllamaTemperature() {
        return this.ollamaTemperature;
    }

    @Generated
    public Integer getOllamaTopK() {
        return this.ollamaTopK;
    }

    @Generated
    public Double getOllamaTopP() {
        return this.ollamaTopP;
    }

    @Generated
    public Double getOllamaRepeatPenalty() {
        return this.ollamaRepeatPenalty;
    }

    @Generated
    public Integer getOllamaSeed() {
        return this.ollamaSeed;
    }

    @Generated
    public Integer getOllamaNumPredict() {
        return this.ollamaNumPredict;
    }

    @Generated
    public Integer getOllamaNumCtx() {
        return this.ollamaNumCtx;
    }

    @Generated
    public String getOllamaFormat() {
        return this.ollamaFormat;
    }

    @Generated
    public Integer getOllamaTimeout() {
        return this.ollamaTimeout;
    }

    @Generated
    public Integer getOllamaMaxRetries() {
        return this.ollamaMaxRetries;
    }

    @Generated
    public String getAnthropicBaseUrl() {
        return this.anthropicBaseUrl;
    }

    @Generated
    public String getAnthropicApiKey() {
        return this.anthropicApiKey;
    }

    @Generated
    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    @Generated
    public String getAnthropicModelName() {
        return this.anthropicModelName;
    }

    @Generated
    public Double getAnthropicTemperature() {
        return this.anthropicTemperature;
    }

    @Generated
    public Double getAnthropicTopP() {
        return this.anthropicTopP;
    }

    @Generated
    public Integer getAnthropicTopK() {
        return this.anthropicTopK;
    }

    @Generated
    public Integer getAnthropicMaxTokens() {
        return this.anthropicMaxTokens;
    }

    @Generated
    public Integer getAnthropicTimeout() {
        return this.anthropicTimeout;
    }

    @Generated
    public Integer getAnthropicMaxRetries() {
        return this.anthropicMaxRetries;
    }

    @Generated
    public boolean isAnthropicLogRequests() {
        return this.anthropicLogRequests;
    }

    @Generated
    public boolean isAnthropicLogResponses() {
        return this.anthropicLogResponses;
    }

    @Generated
    public void setInputField(String inputField) {
        this.inputField = inputField;
    }

    @Generated
    public void setInputChatJson(boolean inputChatJson) {
        this.inputChatJson = inputChatJson;
    }

    @Generated
    public void setOutputChatJson(boolean outputChatJson) {
        this.outputChatJson = outputChatJson;
    }

    @Generated
    public void setMock(boolean mock) {
        this.mock = mock;
    }

    @Generated
    public void setOutputFieldNamePrefix(String outputFieldNamePrefix) {
        this.outputFieldNamePrefix = outputFieldNamePrefix;
    }

    @Generated
    public void setMockOutputValue(String mockOutputValue) {
        this.mockOutputValue = mockOutputValue;
    }

    @Generated
    public void setIdentifierValue(String identifierValue) {
        this.identifierValue = identifierValue;
    }

    @Generated
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @Generated
    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    @Generated
    public void setOpenAiBaseUrl(String openAiBaseUrl) {
        this.openAiBaseUrl = openAiBaseUrl;
    }

    @Generated
    public void setOpenAiApiKey(String openAiApiKey) {
        this.openAiApiKey = openAiApiKey;
    }

    @Generated
    public void setOpenAiOrganizationId(String openAiOrganizationId) {
        this.openAiOrganizationId = openAiOrganizationId;
    }

    @Generated
    public void setOpenAiModelName(String openAiModelName) {
        this.openAiModelName = openAiModelName;
    }

    @Generated
    public void setOpenAiTemperature(Double openAiTemperature) {
        this.openAiTemperature = openAiTemperature;
    }

    @Generated
    public void setOpenAiTopP(Double openAiTopP) {
        this.openAiTopP = openAiTopP;
    }

    @Generated
    public void setOpenAiMaxTokens(Integer openAiMaxTokens) {
        this.openAiMaxTokens = openAiMaxTokens;
    }

    @Generated
    public void setOpenAiPresencePenalty(Double openAiPresencePenalty) {
        this.openAiPresencePenalty = openAiPresencePenalty;
    }

    @Generated
    public void setOpenAiFrequencyPenalty(Double openAiFrequencyPenalty) {
        this.openAiFrequencyPenalty = openAiFrequencyPenalty;
    }

    @Generated
    public void setOpenAiResponseFormat(String openAiResponseFormat) {
        this.openAiResponseFormat = openAiResponseFormat;
    }

    @Generated
    public void setOpenAiSeed(Integer openAiSeed) {
        this.openAiSeed = openAiSeed;
    }

    @Generated
    public void setOpenAiUser(String openAiUser) {
        this.openAiUser = openAiUser;
    }

    @Generated
    public void setOpenAiTimeout(Integer openAiTimeout) {
        this.openAiTimeout = openAiTimeout;
    }

    @Generated
    public void setOpenAiMaxRetries(Integer openAiMaxRetries) {
        this.openAiMaxRetries = openAiMaxRetries;
    }

    @Generated
    public void setOpenAiUseProxy(boolean openAiUseProxy) {
        this.openAiUseProxy = openAiUseProxy;
    }

    @Generated
    public void setOpenAiProxyHost(String openAiProxyHost) {
        this.openAiProxyHost = openAiProxyHost;
    }

    @Generated
    public void setOpenAiProxyPort(Integer openAiProxyPort) {
        this.openAiProxyPort = openAiProxyPort;
    }

    @Generated
    public void setOpenAiLogRequests(boolean openAiLogRequests) {
        this.openAiLogRequests = openAiLogRequests;
    }

    @Generated
    public void setOpenAiLogResponses(boolean openAiLogResponses) {
        this.openAiLogResponses = openAiLogResponses;
    }

    @Generated
    public void setHuggingFaceAccessToken(String huggingFaceAccessToken) {
        this.huggingFaceAccessToken = huggingFaceAccessToken;
    }

    @Generated
    public void setHuggingFaceModelId(String huggingFaceModelId) {
        this.huggingFaceModelId = huggingFaceModelId;
    }

    @Generated
    public void setHuggingFaceTimeout(Integer huggingFaceTimeout) {
        this.huggingFaceTimeout = huggingFaceTimeout;
    }

    @Generated
    public void setHuggingFaceTemperature(Double huggingFaceTemperature) {
        this.huggingFaceTemperature = huggingFaceTemperature;
    }

    @Generated
    public void setHuggingFaceMaxNewTokens(Integer huggingFaceMaxNewTokens) {
        this.huggingFaceMaxNewTokens = huggingFaceMaxNewTokens;
    }

    @Generated
    public void setHuggingFaceReturnFullText(boolean huggingFaceReturnFullText) {
        this.huggingFaceReturnFullText = huggingFaceReturnFullText;
    }

    @Generated
    public void setHuggingFaceWaitForModel(boolean huggingFaceWaitForModel) {
        this.huggingFaceWaitForModel = huggingFaceWaitForModel;
    }

    @Generated
    public void setMistralBaseUrl(String mistralBaseUrl) {
        this.mistralBaseUrl = mistralBaseUrl;
    }

    @Generated
    public void setMistralApiKey(String mistralApiKey) {
        this.mistralApiKey = mistralApiKey;
    }

    @Generated
    public void setMistralModelName(String mistralModelName) {
        this.mistralModelName = mistralModelName;
    }

    @Generated
    public void setMistralTemperature(Double mistralTemperature) {
        this.mistralTemperature = mistralTemperature;
    }

    @Generated
    public void setMistralTopP(Double mistralTopP) {
        this.mistralTopP = mistralTopP;
    }

    @Generated
    public void setMistralMaxTokens(Integer mistralMaxTokens) {
        this.mistralMaxTokens = mistralMaxTokens;
    }

    @Generated
    public void setMistralSafePrompt(boolean mistralSafePrompt) {
        this.mistralSafePrompt = mistralSafePrompt;
    }

    @Generated
    public void setMistralRandomSeed(Integer mistralRandomSeed) {
        this.mistralRandomSeed = mistralRandomSeed;
    }

    @Generated
    public void setMistralResponseFormat(String mistralResponseFormat) {
        this.mistralResponseFormat = mistralResponseFormat;
    }

    @Generated
    public void setMistralTimeout(Integer mistralTimeout) {
        this.mistralTimeout = mistralTimeout;
    }

    @Generated
    public void setMistralLogRequests(boolean mistralLogRequests) {
        this.mistralLogRequests = mistralLogRequests;
    }

    @Generated
    public void setMistralLogResponses(boolean mistralLogResponses) {
        this.mistralLogResponses = mistralLogResponses;
    }

    @Generated
    public void setMistralMaxRetries(Integer mistralMaxRetries) {
        this.mistralMaxRetries = mistralMaxRetries;
    }

    @Generated
    public void setOllamaImageEndpoint(String ollamaImageEndpoint) {
        this.ollamaImageEndpoint = ollamaImageEndpoint;
    }

    @Generated
    public void setOllamaModelName(String ollamaModelName) {
        this.ollamaModelName = ollamaModelName;
    }

    @Generated
    public void setOllamaTemperature(Double ollamaTemperature) {
        this.ollamaTemperature = ollamaTemperature;
    }

    @Generated
    public void setOllamaTopK(Integer ollamaTopK) {
        this.ollamaTopK = ollamaTopK;
    }

    @Generated
    public void setOllamaTopP(Double ollamaTopP) {
        this.ollamaTopP = ollamaTopP;
    }

    @Generated
    public void setOllamaRepeatPenalty(Double ollamaRepeatPenalty) {
        this.ollamaRepeatPenalty = ollamaRepeatPenalty;
    }

    @Generated
    public void setOllamaSeed(Integer ollamaSeed) {
        this.ollamaSeed = ollamaSeed;
    }

    @Generated
    public void setOllamaNumPredict(Integer ollamaNumPredict) {
        this.ollamaNumPredict = ollamaNumPredict;
    }

    @Generated
    public void setOllamaNumCtx(Integer ollamaNumCtx) {
        this.ollamaNumCtx = ollamaNumCtx;
    }

    @Generated
    public void setOllamaFormat(String ollamaFormat) {
        this.ollamaFormat = ollamaFormat;
    }

    @Generated
    public void setOllamaTimeout(Integer ollamaTimeout) {
        this.ollamaTimeout = ollamaTimeout;
    }

    @Generated
    public void setOllamaMaxRetries(Integer ollamaMaxRetries) {
        this.ollamaMaxRetries = ollamaMaxRetries;
    }

    @Generated
    public void setAnthropicBaseUrl(String anthropicBaseUrl) {
        this.anthropicBaseUrl = anthropicBaseUrl;
    }

    @Generated
    public void setAnthropicApiKey(String anthropicApiKey) {
        this.anthropicApiKey = anthropicApiKey;
    }

    @Generated
    public void setAnthropicVersion(String anthropicVersion) {
        this.anthropicVersion = anthropicVersion;
    }

    @Generated
    public void setAnthropicModelName(String anthropicModelName) {
        this.anthropicModelName = anthropicModelName;
    }

    @Generated
    public void setAnthropicTemperature(Double anthropicTemperature) {
        this.anthropicTemperature = anthropicTemperature;
    }

    @Generated
    public void setAnthropicTopP(Double anthropicTopP) {
        this.anthropicTopP = anthropicTopP;
    }

    @Generated
    public void setAnthropicTopK(Integer anthropicTopK) {
        this.anthropicTopK = anthropicTopK;
    }

    @Generated
    public void setAnthropicMaxTokens(Integer anthropicMaxTokens) {
        this.anthropicMaxTokens = anthropicMaxTokens;
    }

    @Generated
    public void setAnthropicTimeout(Integer anthropicTimeout) {
        this.anthropicTimeout = anthropicTimeout;
    }

    @Generated
    public void setAnthropicMaxRetries(Integer anthropicMaxRetries) {
        this.anthropicMaxRetries = anthropicMaxRetries;
    }

    @Generated
    public void setAnthropicLogRequests(boolean anthropicLogRequests) {
        this.anthropicLogRequests = anthropicLogRequests;
    }

    @Generated
    public void setAnthropicLogResponses(boolean anthropicLogResponses) {
        this.anthropicLogResponses = anthropicLogResponses;
    }
}

