/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl.complex;

import io.github.spannm.jackcess.DataType;
import io.github.spannm.jackcess.PropertyMap;
import io.github.spannm.jackcess.impl.PropertyMapImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiValueColumnPropertyMap
implements PropertyMap {
    private final PropertyMap primary;
    private final PropertyMap complex;

    public MultiValueColumnPropertyMap(PropertyMap _primary, PropertyMap _complex) {
        this.primary = _primary;
        this.complex = _complex;
    }

    @Override
    public String getName() {
        return this.primary.getName();
    }

    @Override
    public int getSize() {
        return this.primary.getSize() + this.complex.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.primary.isEmpty() && this.complex.isEmpty();
    }

    @Override
    public PropertyMap.Property get(String name) {
        PropertyMap.Property prop = this.primary.get(name);
        if (prop != null) {
            return prop;
        }
        return this.complex.get(name);
    }

    @Override
    public Object getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public Object getValue(String name, Object defaultValue) {
        PropertyMap.Property prop = this.get(name);
        return prop != null ? prop.getValue() : defaultValue;
    }

    @Override
    public PropertyMap.Property put(String name, Object value) {
        return this.put(name, null, value, false);
    }

    @Override
    public PropertyMap.Property put(String name, DataType type, Object value) {
        return this.put(name, type, value, false);
    }

    @Override
    public PropertyMap.Property put(String name, DataType type, Object value, boolean isDdl) {
        if (MultiValueColumnPropertyMap.isPrimaryKey(name)) {
            return this.primary.put(name, DataType.BOOLEAN, value, true);
        }
        return this.complex.put(name, type, value, isDdl);
    }

    @Override
    public void putAll(Iterable<? extends PropertyMap.Property> props) {
        if (props == null) {
            return;
        }
        for (PropertyMap.Property property : props) {
            if (MultiValueColumnPropertyMap.isPrimaryKey(property.getName())) {
                ((PropertyMapImpl)this.primary).put(property);
                continue;
            }
            ((PropertyMapImpl)this.complex).put(property);
        }
    }

    @Override
    public PropertyMap.Property remove(String name) {
        if (MultiValueColumnPropertyMap.isPrimaryKey(name)) {
            return this.primary.remove(name);
        }
        return this.complex.remove(name);
    }

    @Override
    public void save() throws IOException {
        this.primary.save();
        this.complex.save();
    }

    @Override
    public Iterator<PropertyMap.Property> iterator() {
        final ArrayList iters = new ArrayList(2);
        iters.add(this.primary.iterator());
        iters.add(this.complex.iterator());
        return new Iterator<PropertyMap.Property>(){
            private Iterator<PropertyMap.Property> _cur;
            private PropertyMap.Property _next = this.findNext();

            private PropertyMap.Property findNext() {
                while (!iters.isEmpty()) {
                    this._cur = (Iterator)iters.get(0);
                    if (this._cur.hasNext()) {
                        return this._cur.next();
                    }
                    iters.remove(0);
                    this._cur = null;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this._next != null;
            }

            @Override
            public PropertyMap.Property next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PropertyMap.Property prop = this._next;
                this._next = this.findNext();
                return prop;
            }

            @Override
            public void remove() {
                if (this._cur != null) {
                    this._cur.remove();
                    this._cur = null;
                }
            }
        };
    }

    public String toString() {
        return PropertyMapImpl.toString(this);
    }

    private static boolean isPrimaryKey(String name) {
        return "AllowMultipleValues".equals(name);
    }
}

