/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;

public enum SimpleRequestSlotMatchingStrategy implements RequestSlotMatchingStrategy
{
    INSTANCE;


    @Override
    public Collection<RequestSlotMatchingStrategy.RequestSlotMatch> matchRequestsAndSlots(Collection<? extends PhysicalSlot> slots, Collection<PendingRequest> pendingRequests) {
        ArrayList<RequestSlotMatchingStrategy.RequestSlotMatch> resultingMatches = new ArrayList<RequestSlotMatchingStrategy.RequestSlotMatch>();
        LinkedList<PendingRequest> pendingRequestsIndex = new LinkedList<PendingRequest>(pendingRequests);
        block0: for (PhysicalSlot physicalSlot : slots) {
            Iterator pendingRequestIterator = pendingRequestsIndex.iterator();
            while (pendingRequestIterator.hasNext()) {
                PendingRequest pendingRequest = (PendingRequest)pendingRequestIterator.next();
                if (!physicalSlot.getResourceProfile().isMatching(pendingRequest.getResourceProfile())) continue;
                resultingMatches.add(RequestSlotMatchingStrategy.RequestSlotMatch.createFor(pendingRequest, physicalSlot));
                pendingRequestIterator.remove();
                continue block0;
            }
        }
        return resultingMatches;
    }

    public String toString() {
        return SimpleRequestSlotMatchingStrategy.class.getSimpleName();
    }
}

