/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tika;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TikaOutput {
    private final TikaConfig tikaConfig;
    private final Tika tika;
    private final ILogChannel log;
    private final IVariables variables;
    private ParseContext context;
    private Detector detector;
    private Parser parser;
    private Metadata lastMetadata;
    private String encoding = null;
    private boolean prettyPrint = false;

    public TikaOutput(ClassLoader classLoader, ILogChannel log, IVariables variables) throws IOException, MimeTypeException {
        this.tikaConfig = new TikaConfig(classLoader);
        this.log = log;
        this.variables = variables;
        this.tika = new Tika(this.tikaConfig);
        this.context = new ParseContext();
        this.detector = this.tika.getDetector();
        this.parser = this.tika.getParser();
        this.context.set(Parser.class, (Object)this.parser);
        this.context.set(PasswordProvider.class, metadata -> variables.getVariable("TIKA_PASSWORD"));
    }

    private static Writer getOutputWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new OutputStreamWriter(output, encoding);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            return new OutputStreamWriter(output, "UTF-8");
        }
        return new OutputStreamWriter(output);
    }

    private static TransformerHandler getTransformerHandler(OutputStream output, String method, String encoding, boolean prettyPrint) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", method);
        handler.getTransformer().setOutputProperty("indent", prettyPrint ? "yes" : "no");
        if (encoding != null) {
            handler.getTransformer().setOutputProperty("encoding", encoding);
        }
        handler.setResult(new StreamResult(output));
        return handler;
    }

    public final OutputType getXml() {
        return new OutputType(){

            @Override
            protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
                return TikaOutput.getTransformerHandler(output, "xml", TikaOutput.this.encoding, TikaOutput.this.prettyPrint);
            }
        };
    }

    public final OutputType getHTML() {
        return new OutputType(){

            @Override
            protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
                return new ExpandedTitleContentHandler((ContentHandler)TikaOutput.getTransformerHandler(output, "html", TikaOutput.this.encoding, TikaOutput.this.prettyPrint));
            }
        };
    }

    public final OutputType getTEXT() {
        return new OutputType(){

            @Override
            protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
                return new BodyContentHandler(TikaOutput.getOutputWriter(output, TikaOutput.this.encoding));
            }
        };
    }

    public final OutputType getNO_OUTPUT() {
        return new OutputType(){

            @Override
            protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) {
                return new DefaultHandler();
            }
        };
    }

    public final OutputType getTEXT_MAIN() {
        return new OutputType(){

            @Override
            protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
                return new BodyContentHandler(TikaOutput.getOutputWriter(output, TikaOutput.this.encoding));
            }
        };
    }

    public final OutputType getMETADATA() {
        return new OutputType(){

            @Override
            protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
                PrintWriter writer = new PrintWriter(TikaOutput.getOutputWriter(output, TikaOutput.this.encoding));
                return new NoDocumentMetHandler(metadata, writer);
            }
        };
    }

    public final OutputType getJSON() {
        return new OutputType(){

            @Override
            protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
                PrintWriter writer = new PrintWriter(TikaOutput.getOutputWriter(output, TikaOutput.this.encoding));
                return new NoDocumentJSONMetHandler(metadata, writer);
            }
        };
    }

    public Map<String, OutputType> getFileOutputTypeCodes() {
        HashMap<String, OutputType> outputTypeMap = new HashMap<String, OutputType>();
        outputTypeMap.put("Plain text", this.getTEXT());
        outputTypeMap.put("Main content", this.getTEXT_MAIN());
        outputTypeMap.put("Xml", this.getXml());
        outputTypeMap.put("HTML", this.getHTML());
        outputTypeMap.put("JSON", this.getJSON());
        return outputTypeMap;
    }

    private OutputType getTypeByName(String name) {
        return this.getFileOutputTypeCodes().get(name);
    }

    public void parse(InputStream in, String outputFormat, OutputStream out) throws Exception {
        TikaInputStream input = TikaInputStream.get((InputStream)in);
        OutputType type = this.getTypeByName(outputFormat);
        try {
            this.lastMetadata = new Metadata();
            type.process((InputStream)input, out, this.lastMetadata);
        }
        catch (Exception e) {
            throw new HopException("Error processing output type : " + type.toString(), (Throwable)e);
        }
        finally {
            try {
                input.close();
                out.flush();
            }
            catch (Exception e) {
                this.log.logError("Error closing file", (Throwable)e);
            }
        }
    }

    public Metadata getLastMetadata() {
        return this.lastMetadata;
    }

    public void setLastMetadata(Metadata lastMetadata) {
        this.lastMetadata = lastMetadata;
    }

    private class OutputType {
        private OutputType() {
        }

        public void process(InputStream input, OutputStream output, Metadata metadata) throws Exception {
            NoDocumentMetHandler metHandler;
            ContentHandler handler = this.getContentHandler(output, metadata);
            TikaOutput.this.parser.parse(input, handler, metadata, TikaOutput.this.context);
            if (handler instanceof NoDocumentMetHandler && !(metHandler = (NoDocumentMetHandler)handler).metOutput()) {
                metHandler.endDocument();
            }
        }

        protected ContentHandler getContentHandler(OutputStream output, Metadata metadata) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private class NoDocumentJSONMetHandler
    extends NoDocumentMetHandler {
        private NumberFormat formatter;
        private Gson gson;

        public NoDocumentJSONMetHandler(Metadata metadata, PrintWriter writer) {
            super(metadata, writer);
            this.formatter = NumberFormat.getInstance();
            this.gson = new Gson();
        }

        @Override
        public void outputMetadata(String[] names) {
            this.writer.print("{ ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    this.writer.println(", ");
                } else {
                    first = false;
                }
                this.gson.toJson((Object)name, (Appendable)this.writer);
                this.writer.print(":");
                this.outputValues(this.metadata.getValues(name));
            }
            this.writer.print(" }");
        }

        public void outputValues(String[] values) {
            if (values.length > 1) {
                this.writer.print("[");
            }
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                if (i > 0) {
                    this.writer.print(", ");
                }
                if (value == null || value.length() == 0) {
                    this.writer.print("null");
                    continue;
                }
                ParsePosition pos = new ParsePosition(0);
                this.formatter.parse(value, pos);
                if (value.length() == pos.getIndex()) {
                    value = value.replaceFirst("^0+(\\d)", "$1");
                    this.writer.print(value);
                    continue;
                }
                this.gson.toJson((Object)value, (Appendable)this.writer);
            }
            if (values.length > 1) {
                this.writer.print("]");
            }
        }
    }

    private class NoDocumentMetHandler
    extends DefaultHandler {
        protected final Metadata metadata;
        protected PrintWriter writer;
        private boolean metOutput;

        public NoDocumentMetHandler(Metadata metadata, PrintWriter writer) {
            this.metadata = metadata;
            this.writer = writer;
            this.metOutput = false;
        }

        @Override
        public void endDocument() {
            Object[] names = this.metadata.names();
            Arrays.sort(names);
            this.outputMetadata((String[])names);
            this.writer.flush();
            this.metOutput = true;
        }

        public void outputMetadata(String[] names) {
            for (String name : names) {
                for (String value : this.metadata.getValues(name)) {
                    this.writer.println(name + ": " + value);
                }
            }
        }

        public boolean metOutput() {
            return this.metOutput;
        }
    }
}

