/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.DesktopSessionLogInfo;
import com.dropbox.core.v2.teamlog.MobileSessionLogInfo;
import com.dropbox.core.v2.teamlog.WebSessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class SessionLogInfo {
    @Nullable
    protected final String sessionId;

    public SessionLogInfo(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    public SessionLogInfo() {
        this(null);
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SessionLogInfo other = (SessionLogInfo)obj;
            return this.sessionId == other.sessionId || this.sessionId != null && this.sessionId.equals(other.sessionId);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SessionLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SessionLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof WebSessionLogInfo) {
                WebSessionLogInfo.Serializer.INSTANCE.serialize((WebSessionLogInfo)value, g, collapse);
                return;
            }
            if (value instanceof DesktopSessionLogInfo) {
                DesktopSessionLogInfo.Serializer.INSTANCE.serialize((DesktopSessionLogInfo)value, g, collapse);
                return;
            }
            if (value instanceof MobileSessionLogInfo) {
                MobileSessionLogInfo.Serializer.INSTANCE.serialize((MobileSessionLogInfo)value, g, collapse);
                return;
            }
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.sessionId != null) {
                g.writeFieldName("session_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.sessionId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SessionLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            SessionLogInfo value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                String f_sessionId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("session_id".equals(field)) {
                        f_sessionId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                value = new SessionLogInfo(f_sessionId);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("web".equals(tag)) {
                value = WebSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("desktop".equals(tag)) {
                value = DesktopSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("mobile".equals(tag)) {
                value = MobileSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

