/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transforms.mapping.IPutRow;
import org.apache.hop.pipeline.transforms.mapping.MappingIODefinition;
import org.apache.hop.pipeline.transforms.mapping.MappingValueRename;

public class RowOutputDataMapper
extends RowAdapter {
    private MappingIODefinition inputDefinition;
    private MappingIODefinition outputDefinition;
    private boolean first = true;
    private IRowMeta renamedRowMeta;
    private IPutRow iPutRow;

    public RowOutputDataMapper(MappingIODefinition inputDefinition, MappingIODefinition outputDefinition, IPutRow iPutRow) {
        this.inputDefinition = inputDefinition;
        this.outputDefinition = outputDefinition;
        this.iPutRow = iPutRow;
    }

    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        if (this.first) {
            IValueMeta valueMeta;
            this.first = false;
            this.renamedRowMeta = rowMeta.clone();
            if (this.inputDefinition.isRenamingOnOutput()) {
                for (MappingValueRename valueRename : this.inputDefinition.getValueRenames()) {
                    valueMeta = this.renamedRowMeta.searchValueMeta(valueRename.getTargetValueName());
                    if (valueMeta == null) continue;
                    valueMeta.setName(valueRename.getSourceValueName());
                }
            }
            for (MappingValueRename valueRename : this.outputDefinition.getValueRenames()) {
                valueMeta = this.renamedRowMeta.searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta == null) continue;
                valueMeta.setName(valueRename.getTargetValueName());
            }
        }
        this.iPutRow.putRow(this.renamedRowMeta, row);
    }
}

