/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import reactor.core.publisher.Mono;

public interface ObjectSerializer {
    default public <T> T deserializeFromBytes(byte[] data, TypeReference<T> typeReference) {
        return data == null ? this.deserialize(new ByteArrayInputStream(new byte[0]), typeReference) : this.deserialize(new ByteArrayInputStream(data), typeReference);
    }

    public <T> T deserialize(InputStream var1, TypeReference<T> var2);

    default public <T> Mono<T> deserializeFromBytesAsync(byte[] data, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserializeFromBytes(data, typeReference));
    }

    public <T> Mono<T> deserializeAsync(InputStream var1, TypeReference<T> var2);

    default public byte[] serializeToBytes(Object value) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.serialize(stream, value);
        return stream.toByteArray();
    }

    public void serialize(OutputStream var1, Object var2);

    default public Mono<byte[]> serializeToBytesAsync(Object value) {
        return Mono.fromCallable(() -> this.serializeToBytes(value));
    }

    public Mono<Void> serializeAsync(OutputStream var1, Object var2);
}

