/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffListByArrayList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

abstract class AbstractINodeDiffList<N extends INode, A extends INodeAttributes, D extends AbstractINodeDiff<N, A, D>>
implements Iterable<D> {
    private DiffList<D> diffs;

    AbstractINodeDiffList() {
    }

    public final DiffList<D> asList() {
        return this.diffs != null ? DiffList.unmodifiableList(this.diffs) : DiffList.emptyList();
    }

    public void clear() {
        this.diffs = null;
    }

    abstract D createDiff(int var1, N var2);

    abstract A createSnapshotCopy(N var1);

    public final void deleteSnapshotDiff(INode.ReclaimContext reclaimContext, int snapshot, int prior, N currentINode) {
        if (this.diffs == null) {
            return;
        }
        int snapshotIndex = this.diffs.binarySearch(snapshot);
        if (snapshotIndex == 0) {
            if (prior != -1) {
                ((AbstractINodeDiff)this.diffs.get(snapshotIndex)).setSnapshotId(prior);
            } else {
                AbstractINodeDiff removed = (AbstractINodeDiff)this.diffs.remove(0);
                if (this.diffs.isEmpty()) {
                    this.diffs = null;
                }
                removed.destroyDiffAndCollectBlocks(reclaimContext, currentINode);
            }
        } else if (snapshotIndex > 0) {
            AbstractINodeDiff previous = (AbstractINodeDiff)this.diffs.get(snapshotIndex - 1);
            if (previous.getSnapshotId() != prior) {
                ((AbstractINodeDiff)this.diffs.get(snapshotIndex)).setSnapshotId(prior);
            } else {
                AbstractINodeDiff removed = (AbstractINodeDiff)this.diffs.remove(snapshotIndex);
                if (previous.snapshotINode == null) {
                    previous.snapshotINode = removed.snapshotINode;
                }
                previous.combinePosteriorAndCollectBlocks(reclaimContext, currentINode, removed);
                previous.setPosterior(removed.getPosterior());
                removed.setPosterior(null);
            }
        }
    }

    final D addDiff(int latestSnapshotId, N currentINode) {
        return this.addLast(this.createDiff(latestSnapshotId, currentINode));
    }

    private D addLast(D diff) {
        this.createDiffsIfNeeded();
        D last = this.getLast();
        this.diffs.addLast(diff);
        if (last != null) {
            ((AbstractINodeDiff)last).setPosterior(diff);
        }
        return diff;
    }

    final void addFirst(D diff) {
        this.createDiffsIfNeeded();
        AbstractINodeDiff first = this.diffs.isEmpty() ? null : (AbstractINodeDiff)this.diffs.get(0);
        this.diffs.addFirst(diff);
        diff.setPosterior((AbstractINodeDiff)first);
    }

    public final D getLast() {
        if (this.diffs == null) {
            return null;
        }
        int n = this.diffs.size();
        return (D)(n == 0 ? null : (AbstractINodeDiff)this.diffs.get(n - 1));
    }

    DiffList<D> newDiffs() {
        return new DiffListByArrayList(2);
    }

    private void createDiffsIfNeeded() {
        if (this.diffs == null) {
            this.diffs = this.newDiffs();
        }
    }

    public final int getLastSnapshotId() {
        D last = this.getLast();
        return last == null ? 0x7FFFFFFE : ((AbstractINodeDiff)last).getSnapshotId();
    }

    public final int getPrior(int anchorId, boolean exclusive) {
        if (this.diffs == null) {
            return -1;
        }
        if (anchorId == 0x7FFFFFFE) {
            int last = this.getLastSnapshotId();
            if (exclusive && last == anchorId) {
                return -1;
            }
            return last;
        }
        int i = this.diffs.binarySearch(anchorId);
        if (exclusive) {
            if (i == -1 || i == 0) {
                return -1;
            }
            int priorIndex = i > 0 ? i - 1 : -i - 2;
            return ((AbstractINodeDiff)this.diffs.get(priorIndex)).getSnapshotId();
        }
        if (i >= 0) {
            return ((AbstractINodeDiff)this.diffs.get(i)).getSnapshotId();
        }
        if (i < -1) {
            return ((AbstractINodeDiff)this.diffs.get(-i - 2)).getSnapshotId();
        }
        return -1;
    }

    public final int getPrior(int snapshotId) {
        return this.getPrior(snapshotId, false);
    }

    final int updatePrior(int snapshot, int prior) {
        int p = this.getPrior(snapshot, true);
        if (p != 0x7FFFFFFE && Snapshot.ID_INTEGER_COMPARATOR.compare(p, prior) > 0) {
            return p;
        }
        return prior;
    }

    public final D getDiffById(int snapshotId) {
        if (snapshotId == 0x7FFFFFFE || this.diffs == null) {
            return null;
        }
        int i = this.diffs.binarySearch(snapshotId);
        if (i >= 0) {
            return (D)((AbstractINodeDiff)this.diffs.get(i));
        }
        int j = -i - 1;
        return (D)(j < this.diffs.size() ? (AbstractINodeDiff)this.diffs.get(j) : null);
    }

    public final int getSnapshotById(int snapshotId) {
        D diff = this.getDiffById(snapshotId);
        return diff == null ? 0x7FFFFFFE : ((AbstractINodeDiff)diff).getSnapshotId();
    }

    public final int getDiffIndexById(int snapshotId) {
        int diffIndex = this.diffs.binarySearch(snapshotId);
        diffIndex = diffIndex < 0 ? -diffIndex - 1 : diffIndex;
        return diffIndex;
    }

    final int[] changedBetweenSnapshots(Snapshot from, Snapshot to) {
        int laterDiffIndex;
        if (this.diffs == null) {
            return null;
        }
        Snapshot earlier = from;
        Snapshot later = to;
        if (Snapshot.ID_COMPARATOR.compare(from, to) > 0) {
            earlier = to;
            later = from;
        }
        int size = this.diffs.size();
        int earlierDiffIndex = this.getDiffIndexById(earlier.getId());
        int n = laterDiffIndex = later == null ? size : this.getDiffIndexById(later.getId());
        if (earlierDiffIndex == size) {
            return null;
        }
        if (laterDiffIndex == -1 || laterDiffIndex == 0) {
            return null;
        }
        return new int[]{earlierDiffIndex, laterDiffIndex};
    }

    public A getSnapshotINode(int snapshotId, A currentINode) {
        D diff = this.getDiffById(snapshotId);
        Object inode = diff == null ? null : ((AbstractINodeDiff)diff).getSnapshotINode();
        return (A)(inode == null ? currentINode : inode);
    }

    final D checkAndAddLatestSnapshotDiff(int latestSnapshotId, N currentINode) {
        D last = this.getLast();
        return last != null && Snapshot.ID_INTEGER_COMPARATOR.compare(((AbstractINodeDiff)last).getSnapshotId(), latestSnapshotId) >= 0 ? last : this.addDiff(latestSnapshotId, currentINode);
    }

    public D saveSelf2Snapshot(int latestSnapshotId, N currentINode, A snapshotCopy) {
        AbstractINodeDiff diff = null;
        if (latestSnapshotId != 0x7FFFFFFE) {
            diff = (AbstractINodeDiff)this.checkAndAddLatestSnapshotDiff(latestSnapshotId, currentINode);
            if (diff.snapshotINode == null) {
                if (snapshotCopy == null) {
                    snapshotCopy = this.createSnapshotCopy(currentINode);
                }
                diff.saveSnapshotCopy(snapshotCopy);
            }
        }
        return (D)diff;
    }

    @Override
    public Iterator<D> iterator() {
        return this.diffs != null ? this.diffs.iterator() : Collections.emptyIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + (this.diffs != null ? this.diffs : "[]");
    }
}

