/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveFloatCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class FloatCodec
implements PrimitiveFloatCodec {
    @Override
    @NonNull
    public GenericType<Float> getJavaType() {
        return GenericType.FLOAT;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.FLOAT;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof Float;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Float.class || javaClass == Float.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(float value, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes = ByteBuffer.allocate(4);
        bytes.putFloat(0, value);
        return bytes;
    }

    @Override
    public float decodePrimitive(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0.0f;
        }
        if (bytes.remaining() != 4) {
            throw new IllegalArgumentException("Invalid 32-bits float value, expecting 4 bytes but got " + bytes.remaining());
        }
        return bytes.getFloat(bytes.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Float value) {
        return value == null ? "NULL" : Float.toString(value.floatValue());
    }

    @Override
    @Nullable
    public Float parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 32-bits float value from \"%s\"", value));
        }
    }
}

