/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.Map;
import java.util.TreeSet;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.yardstick.cache.IgniteAccountTxAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Account;

public class IgniteAccountTxBenchmark
extends IgniteAccountTxAbstractBenchmark {
    public boolean test(Map<Object, Object> ctx) throws Exception {
        TreeSet<Integer> accountIds = new TreeSet<Integer>();
        int accNum = this.args.batch();
        while (accountIds.size() < accNum) {
            accountIds.add(IgniteAccountTxBenchmark.nextRandom(this.args.range()));
        }
        try (Transaction tx = this.txs.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
            Map accounts = this.cache.getAll(accountIds);
            if (accounts.size() != accNum) {
                throw new Exception("Failed to find accounts: " + accountIds);
            }
            Integer fromId = (Integer)accountIds.iterator().next();
            int fromBalance = ((Account)accounts.get(fromId)).balance();
            for (Integer id : accountIds) {
                if (id.equals(fromId)) continue;
                Account account = (Account)accounts.get(id);
                if (fromBalance <= 0) continue;
                --fromBalance;
                this.cache.put((Object)id, (Object)new Account(account.balance() + 1));
            }
            this.cache.put((Object)fromId, (Object)new Account(fromBalance));
            tx.commit();
        }
        return true;
    }
}

