/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxMetaSerializer;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbTableStorage;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;

public class TxStateRocksDbStorage
implements TxStateStorage {
    private static final int PREFIX_SIZE_BYTES = 6;
    private static final int FULL_KEY_SIZE_BYES = 22;
    private final int partitionId;
    private final TxStateRocksDbTableStorage tableStorage;
    private final Set<RocksIterator> iterators = ConcurrentHashMap.newKeySet();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final byte[] lastAppliedIndexAndTermKey;
    private final TxStateRocksDbSharedStorage sharedStorage;
    private final int tableId;
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    private final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);

    TxStateRocksDbStorage(int partitionId, TxStateRocksDbTableStorage tableStorage) {
        this.partitionId = partitionId;
        this.tableStorage = tableStorage;
        this.sharedStorage = tableStorage.sharedStorage;
        this.tableId = tableStorage.id;
        this.lastAppliedIndexAndTermKey = ByteBuffer.allocate(6).order(ByteOrder.BIG_ENDIAN).putInt(this.tableId).putShort(TxStateRocksDbStorage.shortPartitionId(partitionId)).array();
    }

    private static short shortPartitionId(int intValue) {
        return (short)intValue;
    }

    public void start() {
        this.busy(() -> {
            byte[] indexAndTermBytes = this.readLastAppliedIndexAndTerm(this.sharedStorage.readOptions);
            if (indexAndTermBytes != null) {
                this.lastAppliedIndex = ByteUtils.bytesToLong((byte[])indexAndTermBytes);
                this.lastAppliedTerm = ByteUtils.bytesToLong((byte[])indexAndTermBytes, (int)8);
            }
            return null;
        });
    }

    @Override
    @Nullable
    public TxMeta get(UUID txId) {
        return this.busy(() -> {
            try {
                this.throwExceptionIfStorageInProgressOfRebalance();
                byte[] txMetaBytes = this.sharedStorage.db().get(this.txIdToKey(txId));
                return txMetaBytes == null ? null : TxStateRocksDbStorage.deserializeTxMeta(txMetaBytes);
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Failed to get a value from storage: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
            }
        });
    }

    private static TxMeta deserializeTxMeta(byte[] txMetaBytes) {
        return (TxMeta)VersionedSerialization.fromBytes((byte[])txMetaBytes, (VersionedSerializer)TxMetaSerializer.INSTANCE);
    }

    @Override
    public void putForRebalance(UUID txId, TxMeta txMeta) {
        this.busy(() -> {
            try {
                this.sharedStorage.db().put(this.txIdToKey(txId), TxStateRocksDbStorage.serializeTxMeta(txMeta));
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Failed to put a value into storage: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
            }
        });
    }

    private static byte[] serializeTxMeta(TxMeta txMeta) {
        return VersionedSerialization.toBytes((Object)txMeta, (VersionedSerializer)TxMetaSerializer.INSTANCE);
    }

    @Override
    public boolean compareAndSet(UUID txId, @Nullable TxState txStateExpected, TxMeta txMeta, long commandIndex, long commandTerm) {
        return (Boolean)this.updateData(writeBatch -> {
            boolean result;
            byte[] txIdBytes = this.txIdToKey(txId);
            byte[] txMetaExistingBytes = this.sharedStorage.db().get(this.sharedStorage.readOptions, this.txIdToKey(txId));
            if (txMetaExistingBytes == null && txStateExpected == null) {
                writeBatch.put(txIdBytes, TxStateRocksDbStorage.serializeTxMeta(txMeta));
                result = true;
            } else if (txMetaExistingBytes != null) {
                TxMeta txMetaExisting = TxStateRocksDbStorage.deserializeTxMeta(txMetaExistingBytes);
                if (txMetaExisting.txState() == txStateExpected) {
                    writeBatch.put(txIdBytes, TxStateRocksDbStorage.serializeTxMeta(txMeta));
                    result = true;
                } else {
                    result = txMetaExisting.txState() == txMeta.txState() && Objects.equals(txMetaExisting.commitTimestamp(), txMeta.commitTimestamp());
                }
            } else {
                result = false;
            }
            return result;
        }, commandIndex, commandTerm);
    }

    @Override
    public void remove(UUID txId, long commandIndex, long commandTerm) {
        this.updateData(writeBatch -> {
            this.throwExceptionIfStorageInProgressOfRebalance();
            writeBatch.delete(this.txIdToKey(txId));
            return null;
        }, commandIndex, commandTerm);
    }

    @Override
    public void removeAll(Collection<UUID> txIds, long commandIndex, long commandTerm) {
        Objects.requireNonNull(txIds, "Collection of the transaction IDs intended for removal cannot be null.");
        this.updateData(writeBatch -> {
            this.throwExceptionIfStorageInProgressOfRebalance();
            for (UUID txId : txIds) {
                writeBatch.delete(this.txIdToKey(txId));
            }
            return null;
        }, commandIndex, commandTerm);
    }

    private <T> T updateData(WriteClosure<?> writeClosure, long commandIndex, long commandTerm) {
        return (T)this.busy(() -> {
            Object t;
            WriteBatch writeBatch = new WriteBatch();
            try {
                Object result = writeClosure.apply(writeBatch);
                if (this.state.get() != StorageState.REBALANCE) {
                    this.updateLastApplied(writeBatch, commandIndex, commandTerm);
                }
                this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
                t = result;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Failed to update data in the storage: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
                }
            }
            writeBatch.close();
            return t;
        });
    }

    @Override
    public Cursor<IgniteBiTuple<UUID, TxMeta>> scan() {
        return (Cursor)this.busy(() -> {
            this.throwExceptionIfStorageInProgressOfRebalance();
            byte[] lowerBound = ByteBuffer.allocate(7).order(ByteOrder.BIG_ENDIAN).putInt(this.tableId).putShort(TxStateRocksDbStorage.shortPartitionId(this.partitionId)).put((byte)0).array();
            byte[] upperBound = this.partitionEndPrefix();
            final ReadOptions readOptions = new ReadOptions().setIterateUpperBound((AbstractSlice)new Slice(upperBound));
            final RocksIterator rocksIterator = this.sharedStorage.db().newIterator(readOptions);
            this.iterators.add(rocksIterator);
            try {
                rocksIterator.seek(lowerBound);
            }
            catch (Exception e) {
                this.iterators.remove(rocksIterator);
                rocksIterator.close();
                throw e;
            }
            return new RocksIteratorAdapter<IgniteBiTuple<UUID, TxMeta>>(rocksIterator){

                protected IgniteBiTuple<UUID, TxMeta> decodeEntry(byte[] keyBytes, byte[] valueBytes) {
                    UUID key = TxStateRocksDbStorage.keyToTxId(keyBytes);
                    TxMeta txMeta = TxStateRocksDbStorage.deserializeTxMeta(valueBytes);
                    return new IgniteBiTuple((Object)key, (Object)txMeta);
                }

                public boolean hasNext() {
                    return TxStateRocksDbStorage.this.busy(() -> {
                        TxStateRocksDbStorage.this.throwExceptionIfStorageInProgressOfRebalance();
                        return super.hasNext();
                    });
                }

                public IgniteBiTuple<UUID, TxMeta> next() {
                    return TxStateRocksDbStorage.this.busy(() -> {
                        TxStateRocksDbStorage.this.throwExceptionIfStorageInProgressOfRebalance();
                        return (IgniteBiTuple)super.next();
                    });
                }

                public void close() {
                    TxStateRocksDbStorage.this.iterators.remove(rocksIterator);
                    readOptions.close();
                    super.close();
                }
            };
        });
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.busy(() -> this.sharedStorage.awaitFlush(true));
    }

    @Override
    public long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    @Override
    public long lastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) {
        this.busy(() -> {
            try {
                this.throwExceptionIfStorageInProgressOfRebalance();
                this.sharedStorage.db().put(this.lastAppliedIndexAndTermKey, TxStateRocksDbStorage.indexAndTermToBytes(lastAppliedIndex, lastAppliedTerm));
                this.lastAppliedIndex = lastAppliedIndex;
                this.lastAppliedTerm = lastAppliedTerm;
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Failed to write applied index value to storage: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
            }
        });
    }

    private static byte[] indexAndTermToBytes(long lastAppliedIndex, long lastAppliedTerm) {
        byte[] bytes = new byte[16];
        ByteUtils.putLongToBytes((long)lastAppliedIndex, (byte[])bytes, (int)0);
        ByteUtils.putLongToBytes((long)lastAppliedTerm, (byte[])bytes, (int)8);
        return bytes;
    }

    private byte @Nullable [] readLastAppliedIndexAndTerm(ReadOptions readOptions) {
        try {
            return this.sharedStorage.db().get(readOptions, this.lastAppliedIndexAndTermKey);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Failed to read applied term value from storage: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        if (!this.tryToCloseStorageAndResources()) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            this.clearStorageData(writeBatch);
            writeBatch.delete(this.lastAppliedIndexAndTermKey);
            this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Failed to destroy storage: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
        }
    }

    private byte[] partitionStartPrefix() {
        return ByteBuffer.allocate(6).order(ByteOrder.BIG_ENDIAN).putInt(this.tableId).putShort(TxStateRocksDbStorage.shortPartitionId(this.partitionId)).array();
    }

    private byte[] partitionEndPrefix() {
        return ByteBuffer.allocate(6).order(ByteOrder.BIG_ENDIAN).putInt(this.tableId).putShort(TxStateRocksDbStorage.shortPartitionId(this.partitionId + 1)).array();
    }

    private byte[] txIdToKey(UUID txId) {
        return ByteBuffer.allocate(22).order(ByteOrder.BIG_ENDIAN).putInt(this.tableId).putShort(TxStateRocksDbStorage.shortPartitionId(this.partitionId)).putLong(txId.getMostSignificantBits()).putLong(txId.getLeastSignificantBits()).array();
    }

    private static UUID keyToTxId(byte[] bytes) {
        long msb = ByteUtils.bytesToLong((byte[])bytes, (int)6);
        long lsb = ByteUtils.bytesToLong((byte[])bytes, (int)14);
        return new UUID(msb, lsb);
    }

    @Override
    public void close() {
        this.tryToCloseStorageAndResources();
    }

    @Override
    public CompletableFuture<Void> startRebalance() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.REBALANCE)) {
            this.throwExceptionDependingOnStorageState();
        }
        this.busyLock.block();
        try {
            CompletableFuture completableFuture;
            WriteBatch writeBatch = new WriteBatch();
            try {
                this.clearStorageData(writeBatch);
                this.updateLastApplied(writeBatch, -1L, -1L);
                this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
                completableFuture = CompletableFutures.nullCompletedFuture();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_REBALANCE_ERR, IgniteStringFormatter.format((String)"Failed to start rebalance: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
                }
            }
            writeBatch.close();
            return completableFuture;
        }
        finally {
            this.busyLock.unblock();
        }
    }

    @Override
    public CompletableFuture<Void> abortRebalance() {
        if (this.state.get() != StorageState.REBALANCE) {
            return CompletableFutures.nullCompletedFuture();
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            this.clearStorageData(writeBatch);
            writeBatch.delete(this.lastAppliedIndexAndTermKey);
            this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
            this.lastAppliedIndex = 0L;
            this.lastAppliedTerm = 0L;
            this.state.set(StorageState.RUNNABLE);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_REBALANCE_ERR, IgniteStringFormatter.format((String)"Failed to abort rebalance: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> finishRebalance(long lastAppliedIndex, long lastAppliedTerm) {
        if (this.state.get() != StorageState.REBALANCE) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_REBALANCE_ERR, IgniteStringFormatter.format((String)"Rebalancing has not started: [{}]", (Object[])new Object[]{this.createStorageInfo()}));
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            this.updateLastApplied(writeBatch, lastAppliedIndex, lastAppliedTerm);
            this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
            this.state.set(StorageState.RUNNABLE);
        }
        catch (Exception e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_REBALANCE_ERR, IgniteStringFormatter.format((String)"Failed to finish rebalance: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> clear() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLEANUP)) {
            this.throwExceptionDependingOnStorageState();
        }
        this.busyLock.block();
        try {
            CompletableFuture completableFuture;
            WriteBatch writeBatch = new WriteBatch();
            try {
                this.clearStorageData(writeBatch);
                this.updateLastApplied(writeBatch, 0L, 0L);
                this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
                completableFuture = CompletableFutures.nullCompletedFuture();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Failed to cleanup storage: [{}]", (Object[])new Object[]{this.createStorageInfo()}), (Throwable)e);
                }
            }
            writeBatch.close();
            return completableFuture;
        }
        finally {
            this.state.set(StorageState.RUNNABLE);
            this.busyLock.unblock();
        }
    }

    private void clearStorageData(WriteBatch writeBatch) throws RocksDBException {
        writeBatch.deleteRange(this.partitionStartPrefix(), this.partitionEndPrefix());
    }

    private void updateLastApplied(WriteBatch writeBatch, long lastAppliedIndex, long lastAppliedTerm) throws RocksDBException {
        writeBatch.put(this.lastAppliedIndexAndTermKey, TxStateRocksDbStorage.indexAndTermToBytes(lastAppliedIndex, lastAppliedTerm));
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
    }

    private boolean tryToCloseStorageAndResources() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLOSED)) {
            StorageState state = this.state.get();
            assert (state == StorageState.CLOSED) : state;
            return false;
        }
        this.busyLock.block();
        RocksUtils.closeAll(this.iterators);
        this.iterators.clear();
        return true;
    }

    private void throwExceptionIfStorageInProgressOfRebalance() {
        if (this.state.get() == StorageState.REBALANCE) {
            throw this.createStorageInProgressOfRebalanceException();
        }
    }

    private IgniteInternalException createStorageInProgressOfRebalanceException() {
        return new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_REBALANCE_ERR, IgniteStringFormatter.format((String)"Storage is in the process of rebalance: [{}]", (Object[])new Object[]{this.createStorageInfo()}));
    }

    private void throwExceptionDependingOnStorageState() {
        StorageState state = this.state.get();
        switch (state.ordinal()) {
            case 1: {
                throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_STOPPED_ERR, IgniteStringFormatter.format((String)"Transaction state storage is stopped: [{}]", (Object[])new Object[]{this.createStorageInfo()}));
            }
            case 2: {
                throw this.createStorageInProgressOfRebalanceException();
            }
            case 3: {
                throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Storage is in the process of cleanup: [{}]", (Object[])new Object[]{this.createStorageInfo()}));
            }
        }
        throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format((String)"Unexpected state: [{}, state={}]", (Object[])new Object[]{this.createStorageInfo(), state}));
    }

    private String createStorageInfo() {
        return "table=" + this.tableStorage.id + ", partitionId=" + this.partitionId;
    }

    private <V> V busy(Supplier<V> supplier) {
        if (!this.busyLock.enterBusy()) {
            this.throwExceptionDependingOnStorageState();
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private static enum StorageState {
        RUNNABLE,
        CLOSED,
        REBALANCE,
        CLEANUP;

    }

    @FunctionalInterface
    private static interface WriteClosure<T> {
        public T apply(WriteBatch var1) throws RocksDBException;
    }
}

