/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.annotations.Transferable;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessageGroup;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite.internal.storage.ReadResult;
import org.jetbrains.annotations.Nullable;

/**
 * Snapshot partition data response message.
 */
@Transferable(PartitionReplicationMessageGroup.SNAPSHOT_MV_DATA_RESPONSE)
// TODO: https://issues.apache.org/jira/browse/IGNITE-22522 - remove mentions of commit *table*.
public interface SnapshotMvDataResponse extends NetworkMessage {
    /** List of version chains. */
    List<ResponseEntry> rows();

    /** Flag that indicates whether this is the last response or not. */
    boolean finish();

    /**
     * Single row response as a message.
     */
    @SuppressWarnings("PublicInnerClass")
    @Transferable(PartitionReplicationMessageGroup.SNAPSHOT_MV_DATA_RESPONSE_ENTRY)
    interface ResponseEntry extends NetworkMessage {
        /** Table ID of the table that this row belongs to. */
        int tableId();

        /** Individual row id. */
        UUID rowId();

        /** List of rows for a given {@link #rowId()}. */
        List<BinaryRowMessage> rowVersions();

        /**
         * List of commit timestamps for all committed versions. Might be smaller than {@link #rowVersions()} if there's a write-intent
         * in the chain.
         */
        long[] timestamps();

        /** Transaction id for write-intent if it's present. */
        @Nullable UUID txId();

        /** Commit table/zone id for write-intent if it's present. */
        @Nullable Integer commitTableOrZoneId();

        /** Commit partition id for write-intent if it's present. {@link ReadResult#UNDEFINED_COMMIT_PARTITION_ID} otherwise. */
        int commitPartitionId();
    }
}
