/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

import com.vladsch.flexmark.util.misc.BitField;
import com.vladsch.flexmark.util.misc.DelimitedBuilder;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class BitFieldSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3411599620347842686L;
    long elements = 0L;
    final Class<E> elementType;
    final E[] universe;
    final long[] bitMasks;
    final int totalBits;
    static final Enum<?>[] ZERO_LENGTH_ENUM_ARRAY = new Enum[0];

    public static long nextBitMask(int nextAvailableBit, int bits) {
        return -1L >>> -bits << (int)((long)nextAvailableBit);
    }

    public static <E extends Enum<E>> E[] getUniverse(Class<E> elementType) {
        return UniverseLoader.getUniverseSlow(elementType);
    }

    public static <E extends Enum<E>> long[] getBitMasks(Class<E> elementType) {
        long[] bitMasks = UniverseLoader.enumBitMasksMap.get(elementType);
        if (bitMasks != null) {
            return bitMasks;
        }
        Enum[] universe = UniverseLoader.getUniverseSlow(elementType);
        if (BitField.class.isAssignableFrom(elementType)) {
            int bitCount = 0;
            bitMasks = new long[universe.length];
            for (Enum e : universe) {
                int bits = ((BitField)((Object)e)).getBits();
                if (bits <= 0) {
                    throw new IllegalArgumentException(String.format("Enum bit field %s.%s bits must be >= 1, got: %d", elementType.getSimpleName(), e.name(), bits));
                }
                if (bitCount + bits > 64) {
                    throw new IllegalArgumentException(String.format("Enum bit field %s.%s bits exceed available 64 bits by %d", elementType.getSimpleName(), e.name(), bitCount + bits - 64));
                }
                bitMasks[e.ordinal()] = BitFieldSet.nextBitMask(bitCount, bits);
                bitCount += bits;
            }
        } else if (universe.length <= 64) {
            bitMasks = new long[universe.length];
            for (Enum e : universe) {
                bitMasks[e.ordinal()] = 1L << e.ordinal();
            }
        } else {
            throw new IllegalArgumentException("Enums with more than 64 values are not supported");
        }
        UniverseLoader.enumBitMasksMap.put(elementType, bitMasks);
        return bitMasks;
    }

    BitFieldSet(Class<E> elementType, Enum<?>[] universe, long[] bitMasks) {
        this.elementType = elementType;
        this.universe = universe;
        this.bitMasks = bitMasks;
        this.totalBits = BitFieldSet.getTotalBits(bitMasks);
    }

    public static int getTotalBits(long[] bitMasks) {
        return bitMasks.length == 0 ? 0 : 64 - Long.numberOfLeadingZeros(bitMasks[bitMasks.length - 1]);
    }

    void addRange(E from, E to) {
        this.elements = -1L >>> ((Enum)from).ordinal() - ((Enum)to).ordinal() - 1 << ((Enum)from).ordinal();
    }

    void addAll() {
        if (this.totalBits != 0) {
            this.elements = -1L >>> -this.totalBits;
        }
    }

    public void complement() {
        if (this.totalBits != 0) {
            this.elements ^= 0xFFFFFFFFFFFFFFFFL;
            this.elements &= -1L >>> -this.totalBits;
        }
    }

    public long toLong() {
        return this.elements;
    }

    public int toInt() {
        if (this.totalBits > 32) {
            throw new IllegalArgumentException(String.format("Enum fields use %d bits, which is more than 32 bits available in an int", this.totalBits));
        }
        return (int)this.elements;
    }

    public short toShort() {
        if (this.totalBits > 16) {
            throw new IllegalArgumentException(String.format("Enum fields use %d bits, which is more than 16 bits available in a short", this.totalBits));
        }
        return (short)this.elements;
    }

    public byte toByte() {
        if (this.totalBits > 8) {
            throw new IllegalArgumentException(String.format("Enum fields use %d bits, which is more than 8 bits available in a byte", this.totalBits));
        }
        return (byte)this.elements;
    }

    public long allBitsMask() {
        return -1L >>> -this.totalBits;
    }

    public boolean orMask(long mask) {
        long allValues = -1L >>> -this.totalBits;
        if ((mask & (allValues ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException(String.format("bitMask %d value contains elements outside the universe %s", mask, Long.toBinaryString(mask & (allValues ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        long oldElements = this.elements;
        this.elements |= mask;
        return oldElements != this.elements;
    }

    @Deprecated
    public boolean replaceAll(long mask) {
        return this.setAll(mask);
    }

    public boolean setAll(long mask) {
        long allValues = -1L >>> -this.totalBits;
        if ((mask & (allValues ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException(String.format("mask %d(0b%s) value contains elements outside the universe 0b%s", mask, Long.toBinaryString(mask), Long.toBinaryString(mask & (allValues ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        long oldElements = this.elements;
        this.elements = mask;
        return oldElements != this.elements;
    }

    @Override
    public String toString() {
        if (this.elements == 0L) {
            return this.elementType.getSimpleName() + ": { }";
        }
        DelimitedBuilder out = new DelimitedBuilder(", ");
        out.append(this.elementType.getSimpleName()).append(": { ");
        for (E e : this.universe) {
            if (!this.any(this.mask(e))) continue;
            out.append(((Enum)e).name());
            if (e instanceof BitField && ((BitField)e).getBits() > 1) {
                out.append("(").append(this.getLong(e)).append(")");
            }
            out.mark();
        }
        out.unmark().append(" }");
        return out.toString();
    }

    public boolean andNotMask(long mask) {
        long oldElements = this.elements;
        this.elements &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        return oldElements != this.elements;
    }

    public boolean any(long mask) {
        return (this.elements & mask) != 0L;
    }

    public boolean none(long mask) {
        return (this.elements & mask) == 0L;
    }

    public boolean all(long mask) {
        long allValues = -1L >>> -this.totalBits;
        if ((mask & (allValues ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException(String.format("mask %d(0b%s) value contains elements outside the universe 0b%s", mask, Long.toBinaryString(mask), Long.toBinaryString(mask & (allValues ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        return (this.elements & mask) == mask;
    }

    public static <E extends Enum<E>> long longMask(E e1) {
        long[] bitMasks = BitFieldSet.getBitMasks(e1.getDeclaringClass());
        return bitMasks[e1.ordinal()];
    }

    public static <E extends Enum<E>> int intMask(E e1) {
        long[] bitMasks = BitFieldSet.getBitMasks(e1.getDeclaringClass());
        int totalBits = BitFieldSet.getTotalBits(bitMasks);
        if (totalBits > 32) {
            throw new IllegalArgumentException(String.format("Enum fields use %d, which is more than 32 available in int", totalBits));
        }
        return (int)bitMasks[e1.ordinal()];
    }

    public long get(E e1) {
        long bitMask = this.bitMasks[((Enum)e1).ordinal()];
        return (this.elements & bitMask) >>> Long.numberOfTrailingZeros(bitMask);
    }

    public boolean setUnsigned(E e1, long value) {
        long oldElements = this.elements;
        this.elements = BitFieldSet.setUnsigned(this.elementType, this.bitMasks, this.elements, e1, value);
        return oldElements != this.elements;
    }

    public boolean setSigned(E e1, long value) {
        long oldElements = this.elements;
        this.elements = BitFieldSet.setSigned(this.elementType, this.bitMasks, this.elements, e1, value);
        return oldElements != this.elements;
    }

    public void setBitField(E e1, long value) {
        this.setSigned(e1, value);
    }

    public void setBitField(E e1, int value) {
        this.setSigned(e1, value);
    }

    public void setBitField(E e1, short value) {
        this.setSigned(e1, value);
    }

    public void setBitField(E e1, byte value) {
        this.setSigned(e1, value);
    }

    public void setUnsignedField(E e1, long value) {
        this.setUnsigned(e1, value);
    }

    public void setUnsignedField(E e1, int value) {
        this.setUnsigned(e1, value);
    }

    public void setUnsignedField(E e1, short value) {
        this.setUnsigned(e1, value);
    }

    public void setUnsignedField(E e1, byte value) {
        this.setUnsigned(e1, value);
    }

    public long getUnsigned(E e1, int maxBits, String typeName) {
        return BitFieldSet.getUnsignedBitField(this.elements, e1, maxBits, typeName);
    }

    public long getSigned(E e1, int maxBits, String typeName) {
        return BitFieldSet.getSignedBitField(this.elements, e1, maxBits, typeName);
    }

    public long getLong(E e1) {
        return this.getSigned(e1, 64, "long");
    }

    public int getInt(E e1) {
        return (int)this.getSigned(e1, 32, "int");
    }

    public short getShort(E e1) {
        return (short)this.getSigned(e1, 16, "short");
    }

    public byte getByte(E e1) {
        return (byte)this.getSigned(e1, 8, "byte");
    }

    public int getUInt(E e1) {
        return (int)this.getSigned(e1, 32, "int");
    }

    public short getUShort(E e1) {
        return (short)this.getSigned(e1, 16, "short");
    }

    public byte getUByte(E e1) {
        return (byte)this.getSigned(e1, 8, "byte");
    }

    public static long orMask(long flags, long mask) {
        return flags | mask;
    }

    public static long andNotMask(long flags, long mask) {
        return flags & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean any(long flags, long mask) {
        return (flags & mask) != 0L;
    }

    public static boolean all(long flags, long mask) {
        return (flags & mask) == mask;
    }

    public static boolean none(long flags, long mask) {
        return (flags & mask) == 0L;
    }

    public long mask(E e1) {
        return this.bitMasks[((Enum)e1).ordinal()];
    }

    public long mask(E e1, E e2) {
        return this.bitMasks[((Enum)e1).ordinal()] | this.bitMasks[((Enum)e2).ordinal()];
    }

    public long mask(E e1, E e2, E e3) {
        return this.bitMasks[((Enum)e1).ordinal()] | this.bitMasks[((Enum)e2).ordinal()] | this.bitMasks[((Enum)e3).ordinal()];
    }

    public long mask(E e1, E e2, E e3, E e4) {
        return this.bitMasks[((Enum)e1).ordinal()] | this.bitMasks[((Enum)e2).ordinal()] | this.bitMasks[((Enum)e3).ordinal()] | this.bitMasks[((Enum)e4).ordinal()];
    }

    public long mask(E e1, E e2, E e3, E e4, E e5) {
        return this.bitMasks[((Enum)e1).ordinal()] | this.bitMasks[((Enum)e2).ordinal()] | this.bitMasks[((Enum)e3).ordinal()] | this.bitMasks[((Enum)e4).ordinal()] | this.bitMasks[((Enum)e5).ordinal()];
    }

    @SafeVarargs
    public final long mask(E ... rest) {
        long mask = 0L;
        for (E e : rest) {
            mask |= this.bitMasks[((Enum)e).ordinal()];
        }
        return mask;
    }

    public boolean add(E e1, E e2) {
        return this.orMask(this.mask(e1, e2));
    }

    public boolean add(E e1, E e2, E e3) {
        return this.orMask(this.mask(e1, e2, e3));
    }

    public boolean add(E e1, E e2, E e3, E e4) {
        return this.orMask(this.mask(e1, e2, e3, e4));
    }

    public boolean add(E e1, E e2, E e3, E e4, E e5) {
        return this.orMask(this.mask(e1, e2, e3, e4, e5));
    }

    @Override
    @SafeVarargs
    public final boolean add(E ... rest) {
        return this.orMask(this.mask((E)rest));
    }

    public boolean remove(E e1, E e2) {
        return this.andNotMask(this.mask(e1, e2));
    }

    public boolean remove(E e1, E e2, E e3) {
        return this.andNotMask(this.mask(e1, e2, e3));
    }

    public boolean remove(E e1, E e2, E e3, E e4) {
        return this.andNotMask(this.mask(e1, e2, e3, e4));
    }

    public boolean remove(E e1, E e2, E e3, E e4, E e5) {
        return this.andNotMask(this.mask(e1, e2, e3, e4, e5));
    }

    @SafeVarargs
    public final boolean remove(E ... rest) {
        return this.andNotMask(this.mask((E)rest));
    }

    public boolean any(E e1) {
        return this.any(this.mask(e1));
    }

    public boolean any(E e1, E e2) {
        return this.any(this.mask(e1, e2));
    }

    public boolean any(E e1, E e2, E e3) {
        return this.any(this.mask(e1, e2, e3));
    }

    public boolean any(E e1, E e2, E e3, E e4) {
        return this.any(this.mask(e1, e2, e3, e4));
    }

    public boolean any(E e1, E e2, E e3, E e4, E e5) {
        return this.any(this.mask(e1, e2, e3, e4, e5));
    }

    @SafeVarargs
    public final boolean any(E ... rest) {
        return this.any(this.mask((E)rest));
    }

    public boolean all(E e1) {
        return this.all(this.mask(e1));
    }

    public boolean all(E e1, E e2) {
        return this.all(this.mask(e1, e2));
    }

    public boolean all(E e1, E e2, E e3) {
        return this.all(this.mask(e1, e2, e3));
    }

    public boolean all(E e1, E e2, E e3, E e4) {
        return this.all(this.mask(e1, e2, e3, e4));
    }

    public boolean all(E e1, E e2, E e3, E e4, E e5) {
        return this.all(this.mask(e1, e2, e3, e4, e5));
    }

    @SafeVarargs
    public final boolean all(E ... rest) {
        return this.all(this.mask((E)rest));
    }

    public boolean none(E e1) {
        return this.none(this.mask(e1));
    }

    public boolean none(E e1, E e2) {
        return this.none(this.mask(e1, e2));
    }

    public boolean none(E e1, E e2, E e3) {
        return this.none(this.mask(e1, e2, e3));
    }

    public boolean none(E e1, E e2, E e3, E e4) {
        return this.none(this.mask(e1, e2, e3, e4));
    }

    public boolean none(E e1, E e2, E e3, E e4, E e5) {
        return this.none(this.mask(e1, e2, e3, e4, e5));
    }

    @SafeVarargs
    public final boolean none(E ... rest) {
        return this.none(this.mask((E)rest));
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.bitMasks.length == this.totalBits ? new EnumBitSetIterator() : new EnumBitFieldIterator();
    }

    @Override
    public int size() {
        return this.totalBits;
    }

    @Override
    public boolean isEmpty() {
        return this.elements == 0L;
    }

    @Override
    public boolean contains(Object e) {
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != this.elementType && eClass.getSuperclass() != this.elementType) {
            return false;
        }
        return (this.elements & this.bitMasks[((Enum)e).ordinal()]) != 0L;
    }

    @Override
    public boolean add(E e) {
        this.typeCheck(e);
        long oldElements = this.elements;
        this.elements |= this.bitMasks[((Enum)e).ordinal()];
        return this.elements != oldElements;
    }

    @Override
    public boolean remove(Object e) {
        if (e == null) {
            return false;
        }
        Class<?> eClass = e.getClass();
        if (eClass != this.elementType && eClass.getSuperclass() != this.elementType) {
            return false;
        }
        long oldElements = this.elements;
        this.elements &= this.bitMasks[((Enum)e).ordinal()] ^ 0xFFFFFFFFFFFFFFFFL;
        return this.elements != oldElements;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (!(c instanceof BitFieldSet)) {
            return super.containsAll(c);
        }
        BitFieldSet es = (BitFieldSet)c;
        if (es.elementType != this.elementType) {
            return es.isEmpty();
        }
        return (es.elements & (this.elements ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (!(c instanceof BitFieldSet)) {
            return super.addAll(c);
        }
        BitFieldSet es = (BitFieldSet)c;
        if (es.elementType != this.elementType) {
            if (es.isEmpty()) {
                return false;
            }
            throw new ClassCastException(es.elementType + " != " + this.elementType);
        }
        long oldElements = this.elements;
        this.elements |= es.elements;
        return this.elements != oldElements;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (!(c instanceof BitFieldSet)) {
            return super.removeAll(c);
        }
        BitFieldSet es = (BitFieldSet)c;
        if (es.elementType != this.elementType) {
            return false;
        }
        long oldElements = this.elements;
        this.elements &= es.elements ^ 0xFFFFFFFFFFFFFFFFL;
        return this.elements != oldElements;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!(c instanceof BitFieldSet)) {
            return super.retainAll(c);
        }
        BitFieldSet es = (BitFieldSet)c;
        if (es.elementType != this.elementType) {
            boolean changed = this.elements != 0L;
            this.elements = 0L;
            return changed;
        }
        long oldElements = this.elements;
        this.elements &= es.elements;
        return this.elements != oldElements;
    }

    @Override
    public void clear() {
        this.elements = 0L;
    }

    public static <T extends Enum<T>> BitFieldSet<T> of(@NotNull Class<T> enumClass, long mask) {
        BitFieldSet<T> optionSet = BitFieldSet.noneOf(enumClass);
        optionSet.orMask(mask);
        return optionSet;
    }

    public BitFieldSet<E> clone() {
        try {
            return (BitFieldSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    final void typeCheck(E e) {
        Class<?> eClass = e.getClass();
        if (eClass != this.elementType && eClass.getSuperclass() != this.elementType) {
            throw new ClassCastException(eClass + " != " + this.elementType);
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BitFieldSet)) {
            return super.equals(o);
        }
        BitFieldSet es = (BitFieldSet)o;
        if (es.elementType != this.elementType) {
            return this.elements == 0L && es.elements == 0L;
        }
        return es.elements == this.elements;
    }

    public static <E extends Enum<E>> BitFieldSet<E> noneOf(Class<E> elementType) {
        if (!elementType.isEnum()) {
            throw new ClassCastException(elementType + " not an enum");
        }
        Enum[] universe = BitFieldSet.getUniverse(elementType);
        return new BitFieldSet<E>(elementType, universe, BitFieldSet.getBitMasks(elementType));
    }

    static <E extends Enum<E>> long setSigned(long elements, E e1, long value) {
        Class<E> elementType = e1.getDeclaringClass();
        long[] bitMasks = BitFieldSet.getBitMasks(elementType);
        return BitFieldSet.setSigned(elementType, bitMasks, elements, e1, value);
    }

    static <E extends Enum<E>> long setSigned(Class<E> elementType, long[] bitMasks, long elements, E e1, long value) {
        long bitMask = bitMasks[e1.ordinal()];
        int bitCount = Long.bitCount(bitMask);
        long halfValue = 1L << bitCount - 1;
        if (bitCount < 64 && (value < -halfValue || value > halfValue - 1L)) {
            throw new IllegalArgumentException(String.format("Enum field %s.%s is %d bit%s, value range is [%d, %d], cannot be set to %d", elementType.getSimpleName(), e1.name(), bitCount, bitCount > 1 ? "s" : "", -halfValue, halfValue - 1L, value));
        }
        long shiftedValue = value << Long.numberOfTrailingZeros(bitMask);
        return elements ^ (elements ^ shiftedValue) & bitMask;
    }

    static <E extends Enum<E>> long setUnsigned(long elements, E e1, long value) {
        Class<E> elementType = e1.getDeclaringClass();
        long[] bitMasks = BitFieldSet.getBitMasks(elementType);
        return BitFieldSet.setUnsigned(elementType, bitMasks, elements, e1, value);
    }

    static <E extends Enum<E>> long setUnsigned(Class<E> elementType, long[] bitMasks, long elements, E e1, long value) {
        long bitMask = bitMasks[e1.ordinal()];
        int bitCount = Long.bitCount(bitMask);
        long maxValue = 1L << bitCount;
        if (bitCount < 64 && (value < 0L || value >= maxValue)) {
            throw new IllegalArgumentException(String.format("Enum field %s.%s is %d bit%s, value range is [0, %d), cannot be set to %d", elementType.getSimpleName(), e1.name(), bitCount, bitCount > 1 ? "s" : "", maxValue - 1L, value));
        }
        long shiftedValue = value << Long.numberOfTrailingZeros(bitMask);
        return elements ^ (elements ^ shiftedValue) & bitMask;
    }

    public static <E extends Enum<E>> long setBitField(long elements, E e1, int value) {
        return BitFieldSet.setUnsigned(elements, e1, value);
    }

    public static <E extends Enum<E>> int setBitField(int elements, E e1, int value) {
        return (int)BitFieldSet.setUnsigned(elements, e1, value);
    }

    public static <E extends Enum<E>> short setBitField(short elements, E e1, short value) {
        return (short)BitFieldSet.setUnsigned(elements, e1, value);
    }

    public static <E extends Enum<E>> byte setBitField(byte elements, E e1, byte value) {
        return (byte)BitFieldSet.setUnsigned(elements, e1, value);
    }

    public static <E extends Enum<E>> long getUnsignedBitField(long elements, E e1, int maxBits, String typeName) {
        Class<E> elementType = e1.getDeclaringClass();
        long[] bitMasks = BitFieldSet.getBitMasks(elementType);
        long bitMask = bitMasks[e1.ordinal()];
        int bitCount = Long.bitCount(bitMask);
        if (bitCount > maxBits) {
            throw new IllegalArgumentException(String.format("Enum field %s.%s uses %d, which is more than %d available in %s", elementType.getSimpleName(), e1.name(), bitCount, maxBits, typeName));
        }
        return (elements & bitMask) >>> Long.numberOfTrailingZeros(bitMask);
    }

    static <E extends Enum<E>> long getSignedBitField(long elements, E e1, int maxBits, String typeName) {
        Class<E> elementType = e1.getDeclaringClass();
        long[] bitMasks = BitFieldSet.getBitMasks(elementType);
        long bitMask = bitMasks[e1.ordinal()];
        int bitCount = Long.bitCount(bitMask);
        if (bitCount > maxBits) {
            throw new IllegalArgumentException(String.format("Enum field %s.%s uses %d, which is more than %d available in %s", elementType.getSimpleName(), e1.name(), bitCount, maxBits, typeName));
        }
        return elements << Long.numberOfLeadingZeros(bitMask) >> 64 - bitCount;
    }

    public static <E extends Enum<E>> long getBitField(long elements, E e1) {
        return BitFieldSet.getUnsignedBitField(elements, e1, 64, "long");
    }

    public static <E extends Enum<E>> int getBitField(int elements, E e1) {
        return (int)BitFieldSet.getUnsignedBitField(elements, e1, 32, "int");
    }

    public static <E extends Enum<E>> short getBitField(short elements, E e1) {
        return (short)BitFieldSet.getUnsignedBitField(elements, e1, 16, "short");
    }

    public static <E extends Enum<E>> byte getBitField(byte elements, E e1) {
        return (byte)BitFieldSet.getUnsignedBitField(elements, e1, 8, "byte");
    }

    public static <E extends Enum<E>> BitFieldSet<E> allOf(Class<E> elementType) {
        BitFieldSet<E> result = BitFieldSet.noneOf(elementType);
        result.addAll();
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> copyOf(BitFieldSet<E> s) {
        return s.clone();
    }

    public static <E extends Enum<E>> BitFieldSet<E> copyOf(Collection<E> c) {
        if (c instanceof BitFieldSet) {
            return ((BitFieldSet)c).clone();
        }
        if (c.isEmpty()) {
            throw new IllegalArgumentException("Collection is empty");
        }
        Iterator<E> i = c.iterator();
        Enum first = (Enum)i.next();
        BitFieldSet<Enum> result = BitFieldSet.of(first);
        while (i.hasNext()) {
            result.add((Enum)i.next());
        }
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> complementOf(BitFieldSet<E> s) {
        BitFieldSet<E> result = BitFieldSet.copyOf(s);
        result.complement();
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> of(E e) {
        BitFieldSet<E> result = BitFieldSet.noneOf(e.getDeclaringClass());
        result.add(e);
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> of(E e1, E e2) {
        BitFieldSet<E> result = BitFieldSet.noneOf(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> of(E e1, E e2, E e3) {
        BitFieldSet<E> result = BitFieldSet.noneOf(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> of(E e1, E e2, E e3, E e4) {
        BitFieldSet<E> result = BitFieldSet.noneOf(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        BitFieldSet<E> result = BitFieldSet.noneOf(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        result.add(e5);
        return result;
    }

    @SafeVarargs
    public static <E extends Enum<E>> BitFieldSet<E> of(E first, E ... rest) {
        BitFieldSet<E> result = BitFieldSet.noneOf(first.getDeclaringClass());
        result.add(first);
        for (E e : rest) {
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> of(@NotNull Class<E> declaringClass, E[] rest) {
        BitFieldSet<E> result = BitFieldSet.noneOf(declaringClass);
        for (E e : rest) {
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum<E>> BitFieldSet<E> range(E from, E to) {
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        BitFieldSet<E> result = BitFieldSet.noneOf(from.getDeclaringClass());
        result.addRange(from, to);
        return result;
    }

    private static class SerializationProxy<E extends Enum<E>>
    implements Serializable {
        private final Class<E> elementType;
        private final long bits;
        private static final long serialVersionUID = 362491234563181265L;

        SerializationProxy(BitFieldSet<E> set) {
            this.elementType = set.elementType;
            this.bits = set.elements;
        }

        private Object readResolve() {
            BitFieldSet<E> result = BitFieldSet.noneOf(this.elementType);
            result.orMask(this.bits);
            return result;
        }
    }

    private class EnumBitFieldIterator<E extends Enum<E>>
    implements Iterator<E> {
        int nextIndex = -1;
        int lastReturnedIndex = -1;

        EnumBitFieldIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < BitFieldSet.this.universe.length;
        }

        @Override
        public E next() {
            if (this.nextIndex >= BitFieldSet.this.universe.length) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.nextIndex;
            this.findNext();
            return BitFieldSet.this.universe[this.lastReturnedIndex];
        }

        void findNext() {
            do {
                ++this.nextIndex;
            } while (this.nextIndex < BitFieldSet.this.universe.length && (BitFieldSet.this.elements & BitFieldSet.this.bitMasks[this.nextIndex]) == 0L);
        }

        @Override
        public void remove() {
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            BitFieldSet.this.elements &= BitFieldSet.this.bitMasks[this.lastReturnedIndex] ^ 0xFFFFFFFFFFFFFFFFL;
            this.lastReturnedIndex = -1;
        }
    }

    private class EnumBitSetIterator<E extends Enum<E>>
    implements Iterator<E> {
        long unseen;
        long lastReturned = 0L;

        EnumBitSetIterator() {
            this.unseen = BitFieldSet.this.elements;
        }

        @Override
        public boolean hasNext() {
            return this.unseen != 0L;
        }

        @Override
        public E next() {
            if (this.unseen == 0L) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.unseen & -this.unseen;
            this.unseen -= this.lastReturned;
            return BitFieldSet.this.universe[Long.numberOfTrailingZeros(this.lastReturned)];
        }

        @Override
        public void remove() {
            if (this.lastReturned == 0L) {
                throw new IllegalStateException();
            }
            BitFieldSet.this.elements &= this.lastReturned ^ 0xFFFFFFFFFFFFFFFFL;
            this.lastReturned = 0L;
        }
    }

    static class UniverseLoader {
        static final ConcurrentHashMap<Class, Enum[]> enumUniverseMap = new ConcurrentHashMap();
        static final ConcurrentHashMap<Class, long[]> enumBitMasksMap = new ConcurrentHashMap();

        UniverseLoader() {
        }

        @NotNull
        public static Enum[] getUniverseSlow(Class elementType) {
            assert (elementType.isEnum());
            Enum[] cachedUniverse = enumUniverseMap.get(elementType);
            if (cachedUniverse != null) {
                return cachedUniverse;
            }
            Field[] fields = elementType.getFields();
            int enums = 0;
            for (Field field : fields) {
                if (!field.getType().isEnum()) continue;
                ++enums;
            }
            if (enums > 0) {
                cachedUniverse = new Enum[enums];
                enums = 0;
                for (Field field : fields) {
                    if (!field.getType().isEnum()) continue;
                    cachedUniverse[enums++] = Enum.valueOf(field.getType(), field.getName());
                }
            } else {
                cachedUniverse = ZERO_LENGTH_ENUM_ARRAY;
            }
            enumUniverseMap.put(elementType, cachedUniverse);
            return cachedUniverse;
        }
    }
}

