/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessage;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessageBuilder;
import org.apache.ignite.internal.tx.message.FinishedTransactionsBatchMessageSerializer;

public class FinishedTransactionsBatchMessageImpl
implements FinishedTransactionsBatchMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 10;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final Collection<UUID> transactions;

    private FinishedTransactionsBatchMessageImpl(HybridTimestamp timestamp, Collection<UUID> transactions) {
        this.timestamp = timestamp;
        this.transactions = transactions;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public Collection<UUID> transactions() {
        return this.transactions;
    }

    public MessageSerializer serializer() {
        return FinishedTransactionsBatchMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(FinishedTransactionsBatchMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 10;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FinishedTransactionsBatchMessageImpl otherMessage = (FinishedTransactionsBatchMessageImpl)other;
        return Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactions, otherMessage.transactions);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.timestamp, this.transactions);
        return result;
    }

    public FinishedTransactionsBatchMessageImpl clone() {
        try {
            return (FinishedTransactionsBatchMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FinishedTransactionsBatchMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements FinishedTransactionsBatchMessageBuilder {
        private HybridTimestamp timestamp;
        private Collection<UUID> transactions;

        private Builder() {
        }

        @Override
        public FinishedTransactionsBatchMessageBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public FinishedTransactionsBatchMessageBuilder transactions(Collection<UUID> transactions) {
            Objects.requireNonNull(transactions, "transactions is not marked @Nullable");
            this.transactions = transactions;
            return this;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public Collection<UUID> transactions() {
            return this.transactions;
        }

        @Override
        public FinishedTransactionsBatchMessage build() {
            return new FinishedTransactionsBatchMessageImpl(this.timestamp, Objects.requireNonNull(this.transactions, "transactions is not marked @Nullable"));
        }
    }
}

