/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.trafficgovernor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.hash.Funnel;
import com.google.protobuf.ByteString;
import io.grpc.inprocess.InProcessSocketAddress;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.base.util.RendezvousHash;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.baserpc.proto.RPCServer;
import org.apache.bifromq.baserpc.trafficgovernor.GlobalProcessId;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceLandscape;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceServerRegister;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficGovernor;
import org.apache.bifromq.baserpc.trafficgovernor.RPCServiceAnnouncer;
import org.apache.bifromq.baserpc.trafficgovernor.ServerEndpoint;
import org.apache.bifromq.baserpc.trafficgovernor.SharedScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RPCServiceTrafficManager
extends RPCServiceAnnouncer
implements IRPCServiceServerRegister,
IRPCServiceLandscape,
IRPCServiceTrafficGovernor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPCServiceTrafficManager.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final BehaviorSubject<Set<ServerEndpoint>> serverEndpointSubject = BehaviorSubject.createDefault(Collections.emptySet());

    public RPCServiceTrafficManager(String serviceUniqueName, ICRDTService crdtService) {
        super(serviceUniqueName, crdtService);
        this.disposables.add(Observable.combineLatest(this.announcedServers(), this.aliveAnnouncers(), this::refreshAliveServerList).observeOn(SharedScheduler.RPC_SHARED_SCHEDULER).subscribe(arg_0 -> this.serverEndpointSubject.onNext(arg_0)));
    }

    @Override
    public Observable<Map<String, Map<String, Integer>>> trafficRules() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        return super.trafficRules();
    }

    @Override
    public Observable<Set<ServerEndpoint>> serverEndpoints() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        return this.serverEndpointSubject;
    }

    @Override
    public IRPCServiceServerRegister.IServerRegistration reg(String id, InetSocketAddress hostAddr, Set<String> groupTags, Map<String, String> attrs) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        return new ServerRegistration(RPCServer.newBuilder().setAgentHostId(this.crdtService.agentHostId()).setId(id).setHost(hostAddr.getAddress().getHostAddress()).setPort(hostAddr.getPort()).setGpid(GlobalProcessId.ID).addAllGroup(groupTags).putAllAttrs(attrs).setAnnouncerId(this.id()).setAnnouncedTS(HLC.INST.get()).build(), this, this.disposables);
    }

    @Override
    public CompletableFuture<Void> setServerGroups(String serverId, Set<String> groupTags) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        Optional<RPCServer> announced = this.announcedServer(serverId);
        if (announced.isPresent()) {
            if (!groupTags.equals(Sets.newHashSet((Iterable)announced.get().getGroupList()))) {
                RPCServer updated = announced.get().toBuilder().clearGroup().addAllGroup(groupTags).setAnnouncedTS(HLC.INST.get()).build();
                return this.announce(updated);
            }
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.failedFuture(new RuntimeException("Server not found: " + serverId));
    }

    @Override
    public CompletableFuture<Void> setTrafficRules(String tenantIdPrefix, Map<String, Integer> loadAssignment) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        return this.setTrafficRule(tenantIdPrefix, loadAssignment);
    }

    @Override
    public CompletableFuture<Void> unsetTrafficRules(String tenantIdPrefix) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        return this.unsetTrafficRule(tenantIdPrefix);
    }

    void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.serverEndpointSubject.onComplete();
            this.disposables.dispose();
            super.destroy();
        }
    }

    private Set<ServerEndpoint> refreshAliveServerList(Map<String, RPCServer> announcedServers, Set<ByteString> aliveAnnouncers) {
        HashSet aliveServers = Sets.newHashSet();
        for (RPCServer server : announcedServers.values()) {
            if (aliveAnnouncers.contains(server.getAnnouncerId())) {
                aliveServers.add(this.build(server));
                continue;
            }
            if (!this.shouldClean(aliveAnnouncers, server.getAnnouncerId())) continue;
            log.debug("Remove not alive server announcement: {}", (Object)server.getId());
            this.revoke(server.getId());
        }
        return aliveServers;
    }

    private boolean shouldClean(Set<ByteString> aliveAnnouncers, ByteString failedAnnouncer) {
        aliveAnnouncers.add(this.id());
        RendezvousHash hash = RendezvousHash.builder().keyFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.asReadOnlyByteBuffer())).nodeFunnel((Funnel & Serializable)(from, into) -> into.putBytes(from.asReadOnlyByteBuffer())).nodes(aliveAnnouncers).build();
        ByteString cleaner = (ByteString)hash.get((Object)failedAnnouncer);
        return cleaner.equals((Object)this.id());
    }

    private ServerEndpoint build(RPCServer server) {
        return new ServerEndpoint(server.getAgentHostId(), server.getId(), server.getHost(), server.getPort(), (SocketAddress)(GlobalProcessId.ID.equals(server.getGpid()) ? new InProcessSocketAddress(server.getId()) : new InetSocketAddress(server.getHost(), server.getPort())), Sets.newHashSet((Iterable)server.getGroupList()), server.getAttrsMap(), GlobalProcessId.ID.equals(server.getGpid()));
    }

    private static class ServerRegistration
    implements IRPCServiceServerRegister.IServerRegistration {
        private final RPCServiceTrafficManager manager;
        private final AtomicReference<RPCServer> localServer;
        private final CompositeDisposable myDisposibles = new CompositeDisposable();
        private final CompositeDisposable allDisposibles;

        private ServerRegistration(RPCServer server, RPCServiceTrafficManager announcer, CompositeDisposable allDisposables) {
            this.localServer = new AtomicReference<RPCServer>(server);
            this.manager = announcer;
            this.allDisposibles = allDisposables;
            log.debug("Announce local server[{}]:{}", (Object)announcer.serviceUniqueName, (Object)server);
            announcer.announce(this.localServer.get()).join();
            this.myDisposibles.add(announcer.announcedServers().doOnDispose(() -> this.manager.revoke(this.localServer.get().getId()).join()).subscribe(serverMap -> {
                RPCServer localServer = this.localServer.get();
                if (!serverMap.containsKey(localServer.getId())) {
                    this.reannounce();
                } else if (localServer.getAnnouncedTS() < ((RPCServer)serverMap.get(localServer.getId())).getAnnouncedTS()) {
                    localServer = (RPCServer)serverMap.get(localServer.getId());
                    log.debug("Update local server from announcement: server={}", (Object)localServer);
                }
            }));
            this.myDisposibles.add(announcer.crdtService.refreshSignal().subscribe(ts -> this.reannounce()));
            allDisposables.add((Disposable)this.myDisposibles);
        }

        private void reannounce() {
            RPCServer localServer = this.localServer.get();
            RPCServer toUpdate = localServer.toBuilder().setAnnouncedTS(HLC.INST.get()).build();
            log.debug("Re-announce local server: {}", (Object)toUpdate);
            this.manager.announce(toUpdate);
        }

        @Override
        public void stop() {
            this.allDisposibles.remove((Disposable)this.myDisposibles);
            this.myDisposibles.dispose();
        }
    }
}

