/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.client.BiDiStream;
import org.apache.bifromq.baserpc.client.DummyServerSelector;
import org.apache.bifromq.baserpc.client.IBiDiStream;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerGroupRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ManagedBiDiStream<InT, OutT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagedBiDiStream.class);
    protected final BluePrint.BalanceMode balanceMode;
    private final AtomicReference<State> state = new AtomicReference<State>(State.Init);
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final String tenantId;
    private final String wchKey;
    private final boolean sticky;
    private final String targetServerId;
    private final Supplier<Map<String, String>> metadataSupplier;
    private final Channel channel;
    private final CallOptions callOptions;
    private final MethodDescriptor<InT, OutT> methodDescriptor;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<BidiStreamContext<InT, OutT>> bidiStream = new AtomicReference(BidiStreamContext.from(new DummyBiDiStream(this)));
    private final AtomicBoolean retargetScheduled = new AtomicBoolean();
    private volatile IServerSelector serverSelector = DummyServerSelector.INSTANCE;

    ManagedBiDiStream(String tenantId, String wchKey, String targetServerId, BluePrint.MethodSemantic methodSemantic, Supplier<Map<String, String>> metadataSupplier, Channel channel, CallOptions callOptions, MethodDescriptor<InT, OutT> methodDescriptor) {
        Preconditions.checkArgument((methodSemantic.mode() != BluePrint.BalanceMode.DDBalanced || targetServerId != null ? 1 : 0) != 0, (Object)"targetServerId is required");
        Preconditions.checkArgument((methodSemantic.mode() != BluePrint.BalanceMode.WCHBalanced || wchKey != null ? 1 : 0) != 0, (Object)"wchKey is required");
        this.tenantId = tenantId;
        this.wchKey = wchKey;
        this.targetServerId = targetServerId;
        this.balanceMode = methodSemantic.mode();
        this.sticky = methodSemantic instanceof BluePrint.HRWPipelineUnaryMethod;
        this.metadataSupplier = metadataSupplier;
        this.channel = channel;
        this.callOptions = callOptions;
        this.methodDescriptor = methodDescriptor;
    }

    void start(Observable<IServerSelector> serverSelectorObservable) {
        this.disposables.add(serverSelectorObservable.subscribeOn(Schedulers.io()).subscribe(this::onServerSelectorChanged));
    }

    State state() {
        return this.state.get();
    }

    final boolean isReady() {
        return this.bidiStream.get().bidiStream().isReady();
    }

    abstract boolean prepareRetarget();

    abstract boolean canStartRetarget();

    abstract void onStreamCreated();

    abstract void onStreamReady();

    abstract void onStreamError(Throwable var1);

    abstract void onNoServerAvailable();

    abstract void onServiceUnavailable();

    private void reportNoServerAvailable() {
        log.debug("Stream@{} no server available to target: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get()});
        this.onNoServerAvailable();
    }

    private void reportServiceUnavailable() {
        log.debug("Stream@{} service unavailable to target: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get()});
        this.onServiceUnavailable();
    }

    abstract void onReceive(OutT var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServerSelectorChanged(IServerSelector newServerSelector) {
        log.debug("Stream@{} server selector changed: method={}, balanceMode={},state={}\n{}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.balanceMode, this.state.get(), newServerSelector});
        block6 : switch (this.balanceMode) {
            case DDBalanced: {
                this.serverSelector = newServerSelector;
                switch (this.state.get()) {
                    case Init: 
                    case StreamDisconnect: 
                    case NoServerAvailable: {
                        this.scheduleRetargetNow();
                        break block6;
                    }
                }
                break;
            }
            case WCHBalanced: {
                Optional<String> newServer;
                IServerGroupRouter router = newServerSelector.get(this.tenantId);
                IServerGroupRouter prevRouter = this.serverSelector.get(this.tenantId);
                this.serverSelector = newServerSelector;
                if (router.isSameGroup(prevRouter)) {
                    return;
                }
                Optional<String> currentServer = prevRouter.hashing(this.wchKey);
                Optional<String> optional = newServer = this.sticky ? router.stickyHashing(this.wchKey) : router.hashing(this.wchKey);
                if (newServer.isEmpty()) {
                    ManagedBiDiStream managedBiDiStream = this;
                    synchronized (managedBiDiStream) {
                        this.bidiStream.get().bidiStream().cancel("No server available");
                        break;
                    }
                }
                if (newServer.equals(currentServer)) break;
                switch (this.state.get()) {
                    case Normal: {
                        this.gracefulRetarget();
                        break block6;
                    }
                    case Init: 
                    case StreamDisconnect: 
                    case NoServerAvailable: {
                        this.scheduleRetargetNow();
                        break block6;
                    }
                }
                break;
            }
            case WRBalanced: {
                IServerGroupRouter router = newServerSelector.get(this.tenantId);
                IServerGroupRouter prevRouter = this.serverSelector.get(this.tenantId);
                this.serverSelector = newServerSelector;
                if (router.isSameGroup(prevRouter)) {
                    return;
                }
                Optional<String> newServer = router.random();
                if (newServer.isEmpty()) {
                    ManagedBiDiStream managedBiDiStream = this;
                    synchronized (managedBiDiStream) {
                        this.bidiStream.get().bidiStream().cancel("No server available");
                        break;
                    }
                }
                switch (this.state.get()) {
                    case Normal: {
                        if (newServer.get().equals(this.bidiStream.get().bidiStream().serverId())) {
                            return;
                        }
                        this.gracefulRetarget();
                        break block6;
                    }
                    case Init: 
                    case StreamDisconnect: 
                    case NoServerAvailable: {
                        this.scheduleRetargetNow();
                        break block6;
                    }
                }
                break;
            }
            default: {
                assert (this.balanceMode == BluePrint.BalanceMode.WRRBalanced);
                IServerGroupRouter router = newServerSelector.get(this.tenantId);
                IServerGroupRouter prevRouter = this.serverSelector.get(this.tenantId);
                this.serverSelector = newServerSelector;
                if (router.isSameGroup(prevRouter)) {
                    return;
                }
                Optional<String> newServer = router.tryRoundRobin();
                if (newServer.isEmpty()) {
                    ManagedBiDiStream managedBiDiStream = this;
                    synchronized (managedBiDiStream) {
                        this.bidiStream.get().bidiStream().cancel("No server available");
                        break;
                    }
                }
                switch (this.state.get()) {
                    case Normal: {
                        this.gracefulRetarget();
                        break block6;
                    }
                    case Init: 
                    case StreamDisconnect: 
                    case NoServerAvailable: {
                        this.scheduleRetargetNow();
                        break block6;
                    }
                }
            }
        }
    }

    void send(InT in) {
        this.bidiStream.get().bidiStream().send(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        ManagedBiDiStream managedBiDiStream = this;
        synchronized (managedBiDiStream) {
            this.disposables.dispose();
            this.bidiStream.get().close();
            this.closed.set(true);
        }
    }

    private void gracefulRetarget() {
        if (this.state.compareAndSet(State.Normal, State.PendingRetarget)) {
            log.debug("Stream@{} start graceful retarget process: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get()});
            if (this.prepareRetarget()) {
                log.debug("Stream@{} close current bidi-stream immediately before retargeting: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get()});
                this.state.set(State.Retargeting);
                this.bidiStream.get().close();
                this.scheduleRetargetNow();
            }
        }
    }

    private void scheduleRetargetWithRandomDelay() {
        long delay = ThreadLocalRandom.current().nextLong(500L, 1500L);
        this.scheduleRetarget(Duration.ofMillis(delay));
    }

    private void scheduleRetargetNow() {
        this.scheduleRetarget(Duration.ZERO);
    }

    private void scheduleRetarget(Duration delay) {
        if (this.retargetScheduled.compareAndSet(false, true)) {
            log.debug("Stream@{} schedule retarget task in {}ms: method={}, state={}", new Object[]{this.hashCode(), delay.toMillis(), this.methodDescriptor.getBareMethodName(), this.state.get()});
            CompletableFuture.runAsync(() -> {
                this.retargetScheduled.set(false);
                this.retarget(this.serverSelector);
            }, CompletableFuture.delayedExecutor(delay.toMillis(), TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retarget(IServerSelector serverSelector) {
        ManagedBiDiStream managedBiDiStream = this;
        synchronized (managedBiDiStream) {
            if (this.closed.get()) {
                return;
            }
            switch (this.balanceMode) {
                case DDBalanced: {
                    boolean available = serverSelector.exists(this.targetServerId);
                    if (available) {
                        this.target(this.targetServerId);
                        break;
                    }
                    this.state.set(State.NoServerAvailable);
                    this.reportNoServerAvailable();
                    break;
                }
                case WCHBalanced: {
                    Optional<String> selectedServer;
                    IServerGroupRouter router = serverSelector.get(this.tenantId);
                    Optional<String> optional = selectedServer = this.sticky ? router.stickyHashing(this.wchKey) : router.hashing(this.wchKey);
                    if (selectedServer.isEmpty()) {
                        this.state.set(State.NoServerAvailable);
                        this.reportServiceUnavailable();
                        break;
                    }
                    this.target(selectedServer.get());
                    break;
                }
                case WRBalanced: {
                    IServerGroupRouter router = serverSelector.get(this.tenantId);
                    Optional<String> selectedServer = router.random();
                    if (selectedServer.isEmpty()) {
                        this.state.set(State.NoServerAvailable);
                        this.reportServiceUnavailable();
                        break;
                    }
                    this.target(selectedServer.get());
                    break;
                }
                default: {
                    assert (this.balanceMode == BluePrint.BalanceMode.WRRBalanced);
                    IServerGroupRouter router = serverSelector.get(this.tenantId);
                    Optional<String> selectedServer = router.roundRobin();
                    if (selectedServer.isEmpty()) {
                        this.state.set(State.NoServerAvailable);
                        this.reportServiceUnavailable();
                        break;
                    }
                    this.target(selectedServer.get());
                }
            }
        }
        if (serverSelector != this.serverSelector) {
            this.scheduleRetargetNow();
        }
    }

    private void target(String serverId) {
        if (this.state.compareAndSet(State.Init, State.Normal) || this.state.compareAndSet(State.StreamDisconnect, State.Normal) || this.state.compareAndSet(State.PendingRetarget, State.Normal) || this.state.compareAndSet(State.NoServerAvailable, State.Normal) || this.state.compareAndSet(State.Retargeting, State.Normal)) {
            log.debug("Stream@{} build stream to server[{}]: method={}, state={}", new Object[]{this.hashCode(), serverId, this.methodDescriptor.getBareMethodName(), this.state.get()});
            BidiStreamContext<InT, OutT> bidiStreamContext = BidiStreamContext.from(new BiDiStream<InT, OutT>(this.tenantId, serverId, this.channel, this.methodDescriptor, this.metadataSupplier.get(), this.callOptions));
            this.bidiStream.set(bidiStreamContext);
            bidiStreamContext.subscribe(this::onNext, (Consumer<Throwable>)((Consumer)this::onError), this::onCompleted);
            bidiStreamContext.onReady((Consumer<Long>)((Consumer)ts -> this.onStreamReady()));
            this.onStreamCreated();
        }
        if (this.bidiStream.get().bidiStream().isReady()) {
            log.debug("Stream@{} ready: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get()});
            this.onStreamReady();
        }
    }

    private void onNext(OutT out) {
        this.onReceive(out);
        if (this.state.get() == State.PendingRetarget && this.canStartRetarget()) {
            CompletableFuture.runAsync(() -> {
                log.debug("Stream@{} close current stream before retargeting: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get()});
                this.state.set(State.Retargeting);
                this.bidiStream.get().close();
                this.scheduleRetargetNow();
            });
        }
    }

    private void onError(Throwable t) {
        log.debug("Stream@{} error: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get(), t});
        State s = this.state.get();
        if (s == State.Normal || s == State.PendingRetarget) {
            this.state.compareAndSet(s, State.StreamDisconnect);
        }
        this.onStreamError(t);
        if (s == State.PendingRetarget) {
            this.scheduleRetargetNow();
        } else {
            this.scheduleRetargetWithRandomDelay();
        }
    }

    private void onCompleted() {
        log.debug("Stream@{} close by server: method={}, state={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), this.state.get()});
        State s = this.state.get();
        if (s == State.Normal || s == State.PendingRetarget) {
            this.state.compareAndSet(s, State.StreamDisconnect);
        }
        this.onStreamError(new CancellationException("Server shutdown"));
        if (s == State.PendingRetarget) {
            this.scheduleRetargetNow();
        }
    }

    static enum State {
        Init,
        Normal,
        PendingRetarget,
        Retargeting,
        StreamDisconnect,
        NoServerAvailable;

    }

    private record DummyBiDiStream<InT, OutT>(ManagedBiDiStream<InT, OutT> managedBiDiStream) implements IBiDiStream<InT, OutT>
    {
        @Override
        public Observable<OutT> onNext() {
            return Observable.empty();
        }

        @Override
        public Observable<Long> onReady() {
            return Observable.empty();
        }

        @Override
        public String serverId() {
            return "";
        }

        @Override
        public boolean isReady() {
            return false;
        }

        @Override
        public void cancel(String message) {
            this.managedBiDiStream.onStreamError(new IllegalStateException("Stream is not ready"));
        }

        @Override
        public void send(InT in) {
            this.managedBiDiStream.onStreamError(new IllegalStateException("Stream is not ready"));
        }

        @Override
        public void close() {
        }
    }

    private record BidiStreamContext<InT, OutT>(IBiDiStream<InT, OutT> bidiStream, CompositeDisposable disposable) {
        static <InT, OutT> BidiStreamContext<InT, OutT> from(IBiDiStream<InT, OutT> bidiStream) {
            return new BidiStreamContext<InT, OutT>(bidiStream, new CompositeDisposable());
        }

        void subscribe(Consumer<OutT> onNext, Consumer<Throwable> onError, Action onComplete) {
            this.disposable.add(this.bidiStream.onNext().subscribe(onNext, onError, onComplete));
        }

        void onReady(Consumer<Long> onReady) {
            this.disposable.add(this.bidiStream.onReady().subscribe(onReady));
        }

        void close() {
            this.disposable.dispose();
            this.bidiStream.close();
        }
    }
}

