/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.base.util;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public final class FutureTracker {
    private final Set<CompletableFuture<?>> track = ConcurrentHashMap.newKeySet();

    public <T> CompletableFuture<T> track(CompletableFuture<T> trackedFuture) {
        this.track.add(trackedFuture);
        trackedFuture.whenComplete((T v, U e) -> this.track.remove(trackedFuture));
        return trackedFuture;
    }

    public void stop() {
        for (CompletableFuture<?> tracked : this.track) {
            tracked.cancel(true);
        }
    }

    public CompletableFuture<Void> whenComplete(BiConsumer<Void, Throwable> biConsumer) {
        return CompletableFuture.allOf(this.track.toArray(new CompletableFuture[0])).whenComplete((BiConsumer)biConsumer);
    }

    public CompletableFuture<Void> whenCompleteAsync(BiConsumer<Void, Throwable> biConsumer, Executor executor) {
        return CompletableFuture.allOf(this.track.toArray(new CompletableFuture[0])).whenCompleteAsync((BiConsumer)biConsumer, executor);
    }
}

