/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.storage;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ServiceOptions;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.core.storage.aws.AwsCredentialsStorageIntegration;
import org.apache.polaris.core.storage.azure.AzureCredentialsStorageIntegration;
import org.apache.polaris.core.storage.gcp.GcpCredentialsStorageIntegration;
import org.apache.polaris.service.storage.PolarisStorageIntegrationProviderImpl;
import org.apache.polaris.service.storage.StorageConfiguration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sts.StsClient;

@ApplicationScoped
public class PolarisStorageIntegrationProviderImpl
implements PolarisStorageIntegrationProvider {
    private final Supplier<StsClient> stsClientSupplier;
    private final Optional<AwsCredentialsProvider> stsCredentials;
    private final Supplier<GoogleCredentials> gcpCredsProvider;

    @Inject
    public PolarisStorageIntegrationProviderImpl(StorageConfiguration storageConfiguration) {
        this(storageConfiguration.stsClientSupplier(false), Optional.ofNullable(storageConfiguration.stsCredentials()), storageConfiguration.gcpCredentialsSupplier());
    }

    public PolarisStorageIntegrationProviderImpl(Supplier<StsClient> stsClientSupplier, Optional<AwsCredentialsProvider> stsCredentials, Supplier<GoogleCredentials> gcpCredsProvider) {
        this.stsClientSupplier = stsClientSupplier;
        this.stsCredentials = stsCredentials;
        this.gcpCredsProvider = gcpCredsProvider;
    }

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> getStorageIntegrationForConfig(PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
        if (polarisStorageConfigurationInfo == null) {
            return null;
        }
        return switch (2.$SwitchMap$org$apache$polaris$core$storage$PolarisStorageConfigurationInfo$StorageType[polarisStorageConfigurationInfo.getStorageType().ordinal()]) {
            case 1 -> new AwsCredentialsStorageIntegration(this.stsClientSupplier.get(), this.stsCredentials);
            case 2 -> new GcpCredentialsStorageIntegration(this.gcpCredsProvider.get(), (HttpTransportFactory)ServiceOptions.getFromServiceLoader(HttpTransportFactory.class, NetHttpTransport::new));
            case 3 -> new AzureCredentialsStorageIntegration();
            case 4 -> new /* Unavailable Anonymous Inner Class!! */;
            default -> throw new IllegalArgumentException("Unknown storage type " + String.valueOf(polarisStorageConfigurationInfo.getStorageType()));
        };
    }

    public PolarisStorageIntegrationProviderImpl() {
    }
}

