/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink.models;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import org.apache.polaris.core.entity.PolarisGrantRecord;

@Entity
@Table(name="GRANT_RECORDS", indexes={@Index(name="GRANT_RECORDS_BY_GRANTEE_INDEX", columnList="granteeCatalogId,granteeId,securableCatalogId,securableId,privilegeCode")})
public class ModelGrantRecord {
    @Id
    private long securableCatalogId;
    @Id
    private long securableId;
    @Id
    private long granteeCatalogId;
    @Id
    private long granteeId;
    @Id
    private int privilegeCode;
    @Version
    private long version;

    public long getSecurableCatalogId() {
        return this.securableCatalogId;
    }

    public long getSecurableId() {
        return this.securableId;
    }

    public long getGranteeCatalogId() {
        return this.granteeCatalogId;
    }

    public long getGranteeId() {
        return this.granteeId;
    }

    public int getPrivilegeCode() {
        return this.privilegeCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelGrantRecord fromGrantRecord(PolarisGrantRecord record) {
        if (record == null) {
            return null;
        }
        return ModelGrantRecord.builder().securableCatalogId(record.getSecurableCatalogId()).securableId(record.getSecurableId()).granteeCatalogId(record.getGranteeCatalogId()).granteeId(record.getGranteeId()).privilegeCode(record.getPrivilegeCode()).build();
    }

    public static PolarisGrantRecord toGrantRecord(ModelGrantRecord model) {
        if (model == null) {
            return null;
        }
        return new PolarisGrantRecord(model.getSecurableCatalogId(), model.getSecurableId(), model.getGranteeCatalogId(), model.getGranteeId(), model.getPrivilegeCode());
    }

    public static final class Builder {
        private final ModelGrantRecord grantRecord = new ModelGrantRecord();

        private Builder() {
        }

        public Builder securableCatalogId(long securableCatalogId) {
            this.grantRecord.securableCatalogId = securableCatalogId;
            return this;
        }

        public Builder securableId(long securableId) {
            this.grantRecord.securableId = securableId;
            return this;
        }

        public Builder granteeCatalogId(long granteeCatalogId) {
            this.grantRecord.granteeCatalogId = granteeCatalogId;
            return this;
        }

        public Builder granteeId(long granteeId) {
            this.grantRecord.granteeId = granteeId;
            return this;
        }

        public Builder privilegeCode(int privilegeCode) {
            this.grantRecord.privilegeCode = privilegeCode;
            return this;
        }

        public ModelGrantRecord build() {
            return this.grantRecord;
        }
    }
}

