/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestinationConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestinationType;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputFormat;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliveryDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeliveryDestination> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeliveryDestination.getter(DeliveryDestination::name)).setter(DeliveryDestination.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DeliveryDestination.getter(DeliveryDestination::arn)).setter(DeliveryDestination.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryDestinationType").getter(DeliveryDestination.getter(DeliveryDestination::deliveryDestinationTypeAsString)).setter(DeliveryDestination.setter(Builder::deliveryDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationType").build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputFormat").getter(DeliveryDestination.getter(DeliveryDestination::outputFormatAsString)).setter(DeliveryDestination.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFormat").build()}).build();
    private static final SdkField<DeliveryDestinationConfiguration> DELIVERY_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deliveryDestinationConfiguration").getter(DeliveryDestination.getter(DeliveryDestination::deliveryDestinationConfiguration)).setter(DeliveryDestination.setter(Builder::deliveryDestinationConfiguration)).constructor(DeliveryDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DeliveryDestination.getter(DeliveryDestination::tags)).setter(DeliveryDestination.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, OUTPUT_FORMAT_FIELD, DELIVERY_DESTINATION_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeliveryDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String deliveryDestinationType;
    private final String outputFormat;
    private final DeliveryDestinationConfiguration deliveryDestinationConfiguration;
    private final Map<String, String> tags;

    private DeliveryDestination(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.outputFormat = builder.outputFormat;
        this.deliveryDestinationConfiguration = builder.deliveryDestinationConfiguration;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(this.deliveryDestinationType);
    }

    public final String deliveryDestinationTypeAsString() {
        return this.deliveryDestinationType;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    public final DeliveryDestinationConfiguration deliveryDestinationConfiguration() {
        return this.deliveryDestinationConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryDestination)) {
            return false;
        }
        DeliveryDestination other = (DeliveryDestination)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString()) && Objects.equals(this.deliveryDestinationConfiguration(), other.deliveryDestinationConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DeliveryDestination").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("DeliveryDestinationType", (Object)this.deliveryDestinationTypeAsString()).add("OutputFormat", (Object)this.outputFormatAsString()).add("DeliveryDestinationConfiguration", (Object)this.deliveryDestinationConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "deliveryDestinationType": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationTypeAsString()));
            }
            case "outputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
            case "deliveryDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("deliveryDestinationType", DELIVERY_DESTINATION_TYPE_FIELD);
        map.put("outputFormat", OUTPUT_FORMAT_FIELD);
        map.put("deliveryDestinationConfiguration", DELIVERY_DESTINATION_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeliveryDestination, T> g) {
        return obj -> g.apply((DeliveryDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String deliveryDestinationType;
        private String outputFormat;
        private DeliveryDestinationConfiguration deliveryDestinationConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryDestination model) {
            this.name(model.name);
            this.arn(model.arn);
            this.deliveryDestinationType(model.deliveryDestinationType);
            this.outputFormat(model.outputFormat);
            this.deliveryDestinationConfiguration(model.deliveryDestinationConfiguration);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return this.deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final DeliveryDestinationConfiguration.Builder getDeliveryDestinationConfiguration() {
            return this.deliveryDestinationConfiguration != null ? this.deliveryDestinationConfiguration.toBuilder() : null;
        }

        public final void setDeliveryDestinationConfiguration(DeliveryDestinationConfiguration.BuilderImpl deliveryDestinationConfiguration) {
            this.deliveryDestinationConfiguration = deliveryDestinationConfiguration != null ? deliveryDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder deliveryDestinationConfiguration(DeliveryDestinationConfiguration deliveryDestinationConfiguration) {
            this.deliveryDestinationConfiguration = deliveryDestinationConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public DeliveryDestination build() {
            return new DeliveryDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeliveryDestination> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder deliveryDestinationType(String var1);

        public Builder deliveryDestinationType(DeliveryDestinationType var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder deliveryDestinationConfiguration(DeliveryDestinationConfiguration var1);

        default public Builder deliveryDestinationConfiguration(Consumer<DeliveryDestinationConfiguration.Builder> deliveryDestinationConfiguration) {
            return this.deliveryDestinationConfiguration((DeliveryDestinationConfiguration)((DeliveryDestinationConfiguration.Builder)DeliveryDestinationConfiguration.builder().applyMutation(deliveryDestinationConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

