/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.IndexPoliciesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.IndexPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIndexPoliciesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeIndexPoliciesResponse> {
    private static final SdkField<List<IndexPolicy>> INDEX_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("indexPolicies").getter(DescribeIndexPoliciesResponse.getter(DescribeIndexPoliciesResponse::indexPolicies)).setter(DescribeIndexPoliciesResponse.setter(Builder::indexPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IndexPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeIndexPoliciesResponse.getter(DescribeIndexPoliciesResponse::nextToken)).setter(DescribeIndexPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIndexPoliciesResponse.memberNameToFieldInitializer();
    private final List<IndexPolicy> indexPolicies;
    private final String nextToken;

    private DescribeIndexPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.indexPolicies = builder.indexPolicies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIndexPolicies() {
        return this.indexPolicies != null && !(this.indexPolicies instanceof SdkAutoConstructList);
    }

    public final List<IndexPolicy> indexPolicies() {
        return this.indexPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndexPolicies() ? this.indexPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexPoliciesResponse)) {
            return false;
        }
        DescribeIndexPoliciesResponse other = (DescribeIndexPoliciesResponse)((Object)obj);
        return this.hasIndexPolicies() == other.hasIndexPolicies() && Objects.equals(this.indexPolicies(), other.indexPolicies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIndexPoliciesResponse").add("IndexPolicies", this.hasIndexPolicies() ? this.indexPolicies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexPolicies": {
                return Optional.ofNullable(clazz.cast(this.indexPolicies()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("indexPolicies", INDEX_POLICIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeIndexPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<IndexPolicy> indexPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexPoliciesResponse model) {
            super(model);
            this.indexPolicies(model.indexPolicies);
            this.nextToken(model.nextToken);
        }

        public final List<IndexPolicy.Builder> getIndexPolicies() {
            List<IndexPolicy.Builder> result = IndexPoliciesCopier.copyToBuilder(this.indexPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexPolicies(Collection<IndexPolicy.BuilderImpl> indexPolicies) {
            this.indexPolicies = IndexPoliciesCopier.copyFromBuilder(indexPolicies);
        }

        @Override
        public final Builder indexPolicies(Collection<IndexPolicy> indexPolicies) {
            this.indexPolicies = IndexPoliciesCopier.copy(indexPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexPolicies(IndexPolicy ... indexPolicies) {
            this.indexPolicies(Arrays.asList(indexPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexPolicies(Consumer<IndexPolicy.Builder> ... indexPolicies) {
            this.indexPolicies(Stream.of(indexPolicies).map(c -> (IndexPolicy)((IndexPolicy.Builder)IndexPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIndexPoliciesResponse build() {
            return new DescribeIndexPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIndexPoliciesResponse> {
        public Builder indexPolicies(Collection<IndexPolicy> var1);

        public Builder indexPolicies(IndexPolicy ... var1);

        public Builder indexPolicies(Consumer<IndexPolicy.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

