/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.db.queryengine.execution.operator.window.ConditionWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;

public class ConditionWindow
implements IWindow {
    private final int controlColumnIndex;
    private final boolean outputEndTime;
    private final boolean ignoringNull;
    private long startTime;
    private long endTime;
    private long keep;
    private boolean timeInitialized;

    public ConditionWindow(ConditionWindowParameter conditionWindowParameter) {
        this.ignoringNull = conditionWindowParameter.isIgnoringNull();
        this.controlColumnIndex = conditionWindowParameter.getControlColumnIndex();
        this.outputEndTime = conditionWindowParameter.isNeedOutputEndTime();
    }

    @Override
    public Column getControlColumn(TsBlock tsBlock) {
        return tsBlock.getColumn(this.controlColumnIndex);
    }

    @Override
    public boolean satisfy(Column column, int index) {
        if (!column.isNull(index)) {
            return column.getBoolean(index);
        }
        return false;
    }

    @Override
    public void mergeOnePoint(Column[] controlTimeAndValueColumn, int index) {
        ++this.keep;
        long currentTime = controlTimeAndValueColumn[1].getLong(index);
        if (!this.timeInitialized) {
            this.startTime = currentTime;
            this.endTime = currentTime;
            this.timeInitialized = true;
        } else {
            this.startTime = Math.min(this.startTime, currentTime);
            this.endTime = Math.max(this.endTime, currentTime);
        }
    }

    @Override
    public boolean contains(Column column) {
        return false;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean ignoringNull() {
        return this.ignoringNull;
    }

    public long getKeep() {
        return this.keep;
    }

    public void setKeep(long keep) {
        this.keep = keep;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setTimeInitialized(boolean timeInitialized) {
        this.timeInitialized = timeInitialized;
    }

    public boolean isOutputEndTime() {
        return this.outputEndTime;
    }
}

