/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

public class X509IdentityToken
extends UserIdentityToken
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=325");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=326");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=327");
    private final ByteString certificateData;

    public X509IdentityToken(String policyId, ByteString certificateData) {
        super(policyId);
        this.certificateData = certificateData;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public ByteString getCertificateData() {
        return this.certificateData;
    }

    protected X509IdentityToken(X509IdentityTokenBuilder<?, ?> b) {
        super((UserIdentityToken.UserIdentityTokenBuilder<?, ?>)b);
        this.certificateData = ((X509IdentityTokenBuilder)b).certificateData;
    }

    public static X509IdentityTokenBuilder<?, ?> builder() {
        return new X509IdentityTokenBuilderImpl();
    }

    public X509IdentityTokenBuilder<?, ?> toBuilder() {
        return new X509IdentityTokenBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509IdentityToken)) {
            return false;
        }
        X509IdentityToken other = (X509IdentityToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteString this$certificateData = this.getCertificateData();
        ByteString other$certificateData = other.getCertificateData();
        return !(this$certificateData == null ? other$certificateData != null : !((Object)this$certificateData).equals(other$certificateData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof X509IdentityToken;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ByteString $certificateData = this.getCertificateData();
        result = result * 59 + ($certificateData == null ? 43 : ((Object)$certificateData).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "X509IdentityToken(certificateData=" + this.getCertificateData() + ")";
    }

    private static final class X509IdentityTokenBuilderImpl
    extends X509IdentityTokenBuilder<X509IdentityToken, X509IdentityTokenBuilderImpl> {
        private X509IdentityTokenBuilderImpl() {
        }

        @Override
        protected X509IdentityTokenBuilderImpl self() {
            return this;
        }

        @Override
        public X509IdentityToken build() {
            return new X509IdentityToken(this);
        }
    }

    public static abstract class X509IdentityTokenBuilder<C extends X509IdentityToken, B extends X509IdentityTokenBuilder<C, B>>
    extends UserIdentityToken.UserIdentityTokenBuilder<C, B> {
        private ByteString certificateData;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            X509IdentityTokenBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(X509IdentityToken instance, X509IdentityTokenBuilder<?, ?> b) {
            b.certificateData(instance.certificateData);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B certificateData(ByteString certificateData) {
            this.certificateData = certificateData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "X509IdentityToken.X509IdentityTokenBuilder(super=" + super.toString() + ", certificateData=" + this.certificateData + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<X509IdentityToken> {
        @Override
        public Class<X509IdentityToken> getType() {
            return X509IdentityToken.class;
        }

        @Override
        public X509IdentityToken decode(SerializationContext context, UaDecoder decoder) {
            String policyId = decoder.readString("PolicyId");
            ByteString certificateData = decoder.readByteString("CertificateData");
            return new X509IdentityToken(policyId, certificateData);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, X509IdentityToken value) {
            encoder.writeString("PolicyId", value.getPolicyId());
            encoder.writeByteString("CertificateData", value.getCertificateData());
        }
    }
}

