/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.BatchedFastAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.FastAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.FastNonAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class FastCompactionPerformerSubTask
implements Callable<Void> {
    private final FastCompactionTaskSummary summary;
    private final AbstractCompactionWriter compactionWriter;
    private final int subTaskId;
    private final Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap;
    private final Map<TsFileResource, TsFileSequenceReader> readerCacheMap;
    private final Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap;
    private final List<TsFileResource> sortedSourceFiles;
    private final boolean isAligned;
    private final boolean ignoreAllNullRows;
    private IDeviceID deviceId;
    private List<String> measurements;
    private List<IMeasurementSchema> measurementSchemas;

    public FastCompactionPerformerSubTask(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, List<String> measurements, IDeviceID deviceId, FastCompactionTaskSummary summary, int subTaskId) {
        this.compactionWriter = compactionWriter;
        this.subTaskId = subTaskId;
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.isAligned = false;
        this.deviceId = deviceId;
        this.readerCacheMap = readerCacheMap;
        this.modificationCacheMap = modificationCacheMap;
        this.sortedSourceFiles = sortedSourceFiles;
        this.measurements = measurements;
        this.summary = summary;
        this.ignoreAllNullRows = true;
    }

    public FastCompactionPerformerSubTask(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, List<IMeasurementSchema> measurementSchemas, IDeviceID deviceId, FastCompactionTaskSummary summary, boolean ignoreAllNullRows) {
        this.compactionWriter = compactionWriter;
        this.subTaskId = 0;
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.isAligned = true;
        this.deviceId = deviceId;
        this.readerCacheMap = readerCacheMap;
        this.modificationCacheMap = modificationCacheMap;
        this.sortedSourceFiles = sortedSourceFiles;
        this.measurementSchemas = measurementSchemas;
        this.summary = summary;
        this.ignoreAllNullRows = ignoreAllNullRows;
    }

    @Override
    public Void call() throws IOException, PageException, WriteProcessException, IllegalPathException {
        if (!this.isAligned) {
            FastNonAlignedSeriesCompactionExecutor seriesCompactionExecutor = new FastNonAlignedSeriesCompactionExecutor(this.compactionWriter, this.readerCacheMap, this.modificationCacheMap, this.sortedSourceFiles, this.deviceId, this.subTaskId, this.summary);
            for (String measurement : this.measurements) {
                seriesCompactionExecutor.setNewMeasurement(this.timeseriesMetadataOffsetMap.get(measurement));
                seriesCompactionExecutor.execute();
            }
        } else {
            FastAlignedSeriesCompactionExecutor seriesCompactionExecutor = this.measurementSchemas.size() - 1 > IoTDBDescriptor.getInstance().getConfig().getCompactionMaxAlignedSeriesNumInOneBatch() ? new BatchedFastAlignedSeriesCompactionExecutor(this.compactionWriter, this.timeseriesMetadataOffsetMap, this.readerCacheMap, this.modificationCacheMap, this.sortedSourceFiles, this.deviceId, this.subTaskId, this.measurementSchemas, this.summary, this.ignoreAllNullRows) : new FastAlignedSeriesCompactionExecutor(this.compactionWriter, this.timeseriesMetadataOffsetMap, this.readerCacheMap, this.modificationCacheMap, this.sortedSourceFiles, this.deviceId, this.subTaskId, this.measurementSchemas, this.summary, this.ignoreAllNullRows);
            seriesCompactionExecutor.execute();
        }
        return null;
    }
}

