/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class NodeTypeDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=573");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=575");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=574");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15201");
    private final ExpandedNodeId typeDefinitionNode;
    private final Boolean includeSubTypes;
    private final QueryDataDescription[] dataToReturn;

    public NodeTypeDescription(ExpandedNodeId typeDefinitionNode, Boolean includeSubTypes, QueryDataDescription[] dataToReturn) {
        this.typeDefinitionNode = typeDefinitionNode;
        this.includeSubTypes = includeSubTypes;
        this.dataToReturn = dataToReturn;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.typeDefinitionNode;
    }

    public Boolean getIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public QueryDataDescription[] getDataToReturn() {
        return this.dataToReturn;
    }

    protected NodeTypeDescription(NodeTypeDescriptionBuilder<?, ?> b) {
        super(b);
        this.typeDefinitionNode = ((NodeTypeDescriptionBuilder)b).typeDefinitionNode;
        this.includeSubTypes = ((NodeTypeDescriptionBuilder)b).includeSubTypes;
        this.dataToReturn = ((NodeTypeDescriptionBuilder)b).dataToReturn;
    }

    public static NodeTypeDescriptionBuilder<?, ?> builder() {
        return new NodeTypeDescriptionBuilderImpl();
    }

    public NodeTypeDescriptionBuilder<?, ?> toBuilder() {
        return new NodeTypeDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeTypeDescription)) {
            return false;
        }
        NodeTypeDescription other = (NodeTypeDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$includeSubTypes = this.getIncludeSubTypes();
        Boolean other$includeSubTypes = other.getIncludeSubTypes();
        if (this$includeSubTypes == null ? other$includeSubTypes != null : !((Object)this$includeSubTypes).equals(other$includeSubTypes)) {
            return false;
        }
        ExpandedNodeId this$typeDefinitionNode = this.getTypeDefinitionNode();
        ExpandedNodeId other$typeDefinitionNode = other.getTypeDefinitionNode();
        if (this$typeDefinitionNode == null ? other$typeDefinitionNode != null : !((Object)this$typeDefinitionNode).equals(other$typeDefinitionNode)) {
            return false;
        }
        return Arrays.deepEquals(this.getDataToReturn(), other.getDataToReturn());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NodeTypeDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeSubTypes = this.getIncludeSubTypes();
        result = result * 59 + ($includeSubTypes == null ? 43 : ((Object)$includeSubTypes).hashCode());
        ExpandedNodeId $typeDefinitionNode = this.getTypeDefinitionNode();
        result = result * 59 + ($typeDefinitionNode == null ? 43 : ((Object)$typeDefinitionNode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDataToReturn());
        return result;
    }

    @Override
    public String toString() {
        return "NodeTypeDescription(typeDefinitionNode=" + this.getTypeDefinitionNode() + ", includeSubTypes=" + this.getIncludeSubTypes() + ", dataToReturn=" + Arrays.deepToString(this.getDataToReturn()) + ")";
    }

    private static final class NodeTypeDescriptionBuilderImpl
    extends NodeTypeDescriptionBuilder<NodeTypeDescription, NodeTypeDescriptionBuilderImpl> {
        private NodeTypeDescriptionBuilderImpl() {
        }

        @Override
        protected NodeTypeDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public NodeTypeDescription build() {
            return new NodeTypeDescription(this);
        }
    }

    public static abstract class NodeTypeDescriptionBuilder<C extends NodeTypeDescription, B extends NodeTypeDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ExpandedNodeId typeDefinitionNode;
        private Boolean includeSubTypes;
        private QueryDataDescription[] dataToReturn;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            NodeTypeDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(NodeTypeDescription instance, NodeTypeDescriptionBuilder<?, ?> b) {
            b.typeDefinitionNode(instance.typeDefinitionNode);
            b.includeSubTypes(instance.includeSubTypes);
            b.dataToReturn(instance.dataToReturn);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B typeDefinitionNode(ExpandedNodeId typeDefinitionNode) {
            this.typeDefinitionNode = typeDefinitionNode;
            return (B)this.self();
        }

        public B includeSubTypes(Boolean includeSubTypes) {
            this.includeSubTypes = includeSubTypes;
            return (B)this.self();
        }

        public B dataToReturn(QueryDataDescription[] dataToReturn) {
            this.dataToReturn = dataToReturn;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "NodeTypeDescription.NodeTypeDescriptionBuilder(super=" + super.toString() + ", typeDefinitionNode=" + this.typeDefinitionNode + ", includeSubTypes=" + this.includeSubTypes + ", dataToReturn=" + Arrays.deepToString(this.dataToReturn) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<NodeTypeDescription> {
        @Override
        public Class<NodeTypeDescription> getType() {
            return NodeTypeDescription.class;
        }

        @Override
        public NodeTypeDescription decode(SerializationContext context, UaDecoder decoder) {
            ExpandedNodeId typeDefinitionNode = decoder.readExpandedNodeId("TypeDefinitionNode");
            Boolean includeSubTypes = decoder.readBoolean("IncludeSubTypes");
            QueryDataDescription[] dataToReturn = (QueryDataDescription[])decoder.readStructArray("DataToReturn", QueryDataDescription.TYPE_ID);
            return new NodeTypeDescription(typeDefinitionNode, includeSubTypes, dataToReturn);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, NodeTypeDescription value) {
            encoder.writeExpandedNodeId("TypeDefinitionNode", value.getTypeDefinitionNode());
            encoder.writeBoolean("IncludeSubTypes", value.getIncludeSubTypes());
            encoder.writeStructArray("DataToReturn", (Object[])value.getDataToReturn(), QueryDataDescription.TYPE_ID);
        }
    }
}

