/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.relational;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum TableBuiltinScalarFunction {
    DIFF("diff"),
    CAST("cast"),
    ROUND("round"),
    REPLACE("replace"),
    SUBSTRING("substring"),
    LENGTH("length"),
    UPPER("upper"),
    LOWER("lower"),
    TRIM("trim"),
    LTRIM("ltrim"),
    RTRIM("rtrim"),
    REGEXP_LIKE("regexp_like"),
    STRPOS("strpos"),
    STARTS_WITH("starts_with"),
    ENDS_WITH("ends_with"),
    CONCAT("concat"),
    STRCMP("strcmp"),
    SIN("sin"),
    COS("cos"),
    TAN("tan"),
    ASIN("asin"),
    ACOS("acos"),
    ATAN("atan"),
    SINH("sinh"),
    COSH("cosh"),
    TANH("tanh"),
    DEGREES("degrees"),
    RADIANS("radians"),
    ABS("abs"),
    SIGN("sign"),
    CEIL("ceil"),
    FLOOR("floor"),
    EXP("exp"),
    LN("ln"),
    LOG10("log10"),
    SQRT("sqrt"),
    PI("pi"),
    E("e"),
    DATE_BIN("date_bin"),
    FORMAT("format"),
    GREATEST("greatest"),
    LEAST("least"),
    BIT_COUNT("bit_count"),
    BITWISE_AND("bitwise_and"),
    BITWISE_NOT("bitwise_not"),
    BITWISE_OR("bitwise_or"),
    BITWISE_XOR("bitwise_xor"),
    BITWISE_LEFT_SHIFT("bitwise_left_shift"),
    BITWISE_RIGHT_SHIFT("bitwise_right_shift"),
    BITWISE_RIGHT_SHIFT_ARITHMETIC("bitwise_right_shift_arithmetic");

    private final String functionName;
    private static final Set<String> BUILT_IN_SCALAR_FUNCTION_NAME;

    private TableBuiltinScalarFunction(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public static Set<String> getBuiltInScalarFunctionName() {
        return BUILT_IN_SCALAR_FUNCTION_NAME;
    }

    static {
        BUILT_IN_SCALAR_FUNCTION_NAME = new HashSet<String>(Arrays.stream(TableBuiltinScalarFunction.values()).map(TableBuiltinScalarFunction::getFunctionName).collect(Collectors.toList()));
    }
}

