/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.ColumnMerger;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;

public class MultiColumnMerger
implements ColumnMerger {
    private final List<InputLocation> inputLocations;

    public MultiColumnMerger(List<InputLocation> inputLocations) {
        this.inputLocations = inputLocations;
    }

    @Override
    public void mergeColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, TimeColumnBuilder timeBuilder, long currentEndTime, ColumnBuilder columnBuilder) {
        int rowCount = timeBuilder.getPositionCount();
        for (InputLocation inputLocation : this.inputLocations) {
            int tsBlockIndex = inputLocation.getTsBlockIndex();
            updatedInputIndex[tsBlockIndex] = inputIndex[tsBlockIndex];
        }
        for (int i = 0; i < rowCount; ++i) {
            boolean appendValue = false;
            for (InputLocation location : this.inputLocations) {
                int tsBlockIndex = location.getTsBlockIndex();
                int columnIndex = location.getValueColumnIndex();
                int index = updatedInputIndex[tsBlockIndex];
                if (ColumnMerger.empty(tsBlockIndex, inputTsBlocks, updatedInputIndex)) continue;
                Column timeColumn = inputTsBlocks[tsBlockIndex].getTimeColumn();
                Column valueColumn = inputTsBlocks[tsBlockIndex].getColumn(columnIndex);
                if (timeColumn.getLong(index) != timeBuilder.getTime(i)) continue;
                if (!valueColumn.isNull(index)) {
                    columnBuilder.write(valueColumn, index);
                    appendValue = true;
                }
                updatedInputIndex[tsBlockIndex] = ++index;
                if (!appendValue) continue;
                break;
            }
            if (appendValue) continue;
            columnBuilder.appendNull();
        }
    }

    @Override
    public void mergeColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, long currentTime, ColumnBuilder columnBuilder) {
        for (InputLocation inputLocation : this.inputLocations) {
            int tsBlockIndex = inputLocation.getTsBlockIndex();
            updatedInputIndex[tsBlockIndex] = inputIndex[tsBlockIndex];
        }
        boolean appendValue = false;
        for (InputLocation location : this.inputLocations) {
            int tsBlockIndex = location.getTsBlockIndex();
            int columnIndex = location.getValueColumnIndex();
            int index = updatedInputIndex[tsBlockIndex];
            if (ColumnMerger.empty(tsBlockIndex, inputTsBlocks, updatedInputIndex)) continue;
            Column timeColumn = inputTsBlocks[tsBlockIndex].getTimeColumn();
            Column valueColumn = inputTsBlocks[tsBlockIndex].getColumn(columnIndex);
            if (timeColumn.getLong(index) != currentTime) continue;
            if (!appendValue && !valueColumn.isNull(index)) {
                columnBuilder.write(valueColumn, index);
                appendValue = true;
            }
            updatedInputIndex[tsBlockIndex] = ++index;
        }
        if (!appendValue) {
            columnBuilder.appendNull();
        }
    }
}

