/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CreateAlignedTimeSeriesNode
extends WritePlanNode
implements ICreateAlignedTimeSeriesPlan {
    private PartialPath devicePath;
    private List<String> measurements;
    private List<TSDataType> dataTypes;
    private List<TSEncoding> encodings;
    private List<CompressionType> compressors;
    private List<String> aliasList;
    private List<Map<String, String>> tagsList;
    private List<Map<String, String>> attributesList;
    private List<Long> tagOffsets = null;
    private TRegionReplicaSet regionReplicaSet;

    public CreateAlignedTimeSeriesNode(PlanNodeId id, PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) {
        super(id);
        this.devicePath = devicePath;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
        this.aliasList = aliasList;
        this.tagsList = tagsList;
        this.attributesList = attributesList;
    }

    @Override
    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    @Override
    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    @Override
    public List<String> getMeasurements() {
        return this.measurements;
    }

    @Override
    public void setMeasurements(List<String> measurements) {
        this.measurements = measurements;
    }

    @Override
    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    @Override
    public void setEncodings(List<TSEncoding> encodings) {
        this.encodings = encodings;
    }

    @Override
    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    @Override
    public void setCompressors(List<CompressionType> compressors) {
        this.compressors = compressors;
    }

    @Override
    public List<String> getAliasList() {
        return this.aliasList;
    }

    @Override
    public void setAliasList(List<String> aliasList) {
        this.aliasList = aliasList;
    }

    @Override
    public List<Map<String, String>> getTagsList() {
        return this.tagsList;
    }

    @Override
    public void setTagsList(List<Map<String, String>> tagsList) {
        this.tagsList = tagsList;
    }

    @Override
    public List<Map<String, String>> getAttributesList() {
        return this.attributesList;
    }

    @Override
    public void setAttributesList(List<Map<String, String>> attributesList) {
        this.attributesList = attributesList;
    }

    @Override
    public List<Long> getTagOffsets() {
        if (this.tagOffsets == null) {
            this.tagOffsets = new ArrayList<Long>();
            for (int i = 0; i < this.measurements.size(); ++i) {
                this.tagOffsets.add(Long.parseLong("-1"));
            }
        }
        return this.tagOffsets;
    }

    @Override
    public void setTagOffsets(List<Long> tagOffsets) {
        this.tagOffsets = tagOffsets;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.CREATE_ALIGNED_TIME_SERIES;
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("Clone of CreateAlignedTimeSeriesNode is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C schemaRegion) {
        return visitor.visitCreateAlignedTimeSeries(this, schemaRegion);
    }

    public static CreateAlignedTimeSeriesNode deserialize(ByteBuffer byteBuffer) {
        int i;
        int i2;
        PartialPath devicePath;
        ArrayList<String> aliasList = null;
        ArrayList<Map<String, String>> tagsList = null;
        ArrayList<Map<String, String>> attributesList = null;
        int length = byteBuffer.getInt();
        byte[] bytes = new byte[length];
        byteBuffer.get(bytes);
        try {
            devicePath = DataNodeDevicePathCache.getInstance().getPartialPath(new String(bytes));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Can not deserialize CreateAlignedTimeSeriesNode", e);
        }
        ArrayList<String> measurements = new ArrayList<String>();
        int size = byteBuffer.getInt();
        for (i2 = 0; i2 < size; ++i2) {
            measurements.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (i2 = 0; i2 < size; ++i2) {
            dataTypes.add(TSDataType.values()[byteBuffer.get()]);
        }
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (i2 = 0; i2 < size; ++i2) {
            encodings.add(TSEncoding.values()[byteBuffer.get()]);
        }
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        for (i2 = 0; i2 < size; ++i2) {
            compressors.add(CompressionType.deserialize((byte)byteBuffer.get()));
        }
        byte label = byteBuffer.get();
        if (label >= 0) {
            aliasList = new ArrayList<String>();
            if (label == 1) {
                for (i = 0; i < size; ++i) {
                    aliasList.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
                }
            }
        }
        if ((label = byteBuffer.get()) >= 0) {
            tagsList = new ArrayList<Map<String, String>>();
            if (label == 1) {
                for (i = 0; i < size; ++i) {
                    tagsList.add(ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
                }
            }
        }
        if ((label = byteBuffer.get()) >= 0) {
            attributesList = new ArrayList<Map<String, String>>();
            if (label == 1) {
                for (i = 0; i < size; ++i) {
                    attributesList.add(ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer));
                }
            }
        }
        String id = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        return new CreateAlignedTimeSeriesNode(new PlanNodeId(id), devicePath, measurements, dataTypes, encodings, compressors, aliasList, tagsList, attributesList);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAlignedTimeSeriesNode that = (CreateAlignedTimeSeriesNode)o;
        return this.getPlanNodeId().equals(that.getPlanNodeId()) && Objects.equals(this.devicePath, that.devicePath) && Objects.equals(this.measurements, that.measurements) && Objects.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.encodings, that.encodings) && Objects.equals(this.compressors, that.compressors) && Objects.equals(this.aliasList, that.aliasList) && Objects.equals(this.tagsList, that.tagsList) && Objects.equals(this.attributesList, that.attributesList);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.CREATE_ALIGNED_TIME_SERIES.serialize(byteBuffer);
        byte[] bytes = this.devicePath.getFullPath().getBytes();
        byteBuffer.putInt(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.putInt(this.measurements.size());
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            byteBuffer.put((byte)tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            byteBuffer.put((byte)tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            byteBuffer.put(compressionType.serialize());
        }
        if (this.aliasList == null) {
            byteBuffer.put((byte)-1);
        } else if (this.aliasList.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            for (String string : this.aliasList) {
                ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
            }
        }
        if (this.tagsList == null) {
            byteBuffer.put((byte)-1);
        } else if (this.tagsList.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            for (Map map : this.tagsList) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)byteBuffer);
            }
        }
        if (this.attributesList == null) {
            byteBuffer.put((byte)-1);
        } else if (this.attributesList.isEmpty()) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            for (Map map : this.attributesList) {
                ReadWriteIOUtils.write((Map)map, (ByteBuffer)byteBuffer);
            }
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.CREATE_ALIGNED_TIME_SERIES.serialize(stream);
        byte[] bytes = this.devicePath.getFullPath().getBytes();
        stream.writeInt(bytes.length);
        stream.write(bytes);
        stream.writeInt(this.measurements.size());
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        for (TSDataType tSDataType : this.dataTypes) {
            stream.write((byte)tSDataType.ordinal());
        }
        for (TSEncoding tSEncoding : this.encodings) {
            stream.write((byte)tSEncoding.ordinal());
        }
        for (CompressionType compressionType : this.compressors) {
            stream.write(compressionType.serialize());
        }
        if (this.aliasList == null) {
            stream.write(-1);
        } else if (this.aliasList.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            for (String string : this.aliasList) {
                ReadWriteIOUtils.write((String)string, (OutputStream)stream);
            }
        }
        if (this.tagsList == null) {
            stream.write(-1);
        } else if (this.tagsList.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            for (Map map : this.tagsList) {
                ReadWriteIOUtils.write((Map)map, (OutputStream)stream);
            }
        }
        if (this.attributesList == null) {
            stream.write(-1);
        } else if (this.attributesList.isEmpty()) {
            stream.write(0);
        } else {
            stream.write(1);
            for (Map map : this.attributesList) {
                ReadWriteIOUtils.write((Map)map, (OutputStream)stream);
            }
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPlanNodeId(), this.devicePath, this.measurements, this.dataTypes, this.encodings, this.compressors, this.aliasList, this.tagsList, this.attributesList);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(this.devicePath.getIDeviceIDAsFullDevice());
        this.setRegionReplicaSet(regionReplicaSet);
        return ImmutableList.of((Object)this);
    }
}

