/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionFileCountExceededException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionLastTimeCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionMemoryNotEnoughException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionValidationFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.FileCannotTransitToCompactingException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InsertionCrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionTaskStage;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.compaction.repair.RepairDataFileScanUtil;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.utils.validate.TsFileValidator;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.tsfile.exception.StopReadTsFileByInterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompactionTask {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected String dataRegionId;
    protected String storageGroupName;
    protected long timePartition;
    protected final TsFileManager tsFileManager;
    protected ICompactionPerformer performer;
    protected int hashCode = -1;
    protected CompactionTaskSummary summary;
    protected long serialId;
    protected CompactionTaskStage taskStage;
    protected long roughMemoryCost = -1L;
    protected long memoryCost = 0L;
    protected boolean recoverMemoryStatus;
    protected boolean needRecoverTaskInfoFromLogFile;
    private boolean memoryAcquired = false;
    private boolean fileHandleAcquired = false;
    protected long compactionConfigVersion = Long.MAX_VALUE;

    protected AbstractCompactionTask(String storageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager, long serialId) {
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.serialId = serialId;
    }

    public abstract List<TsFileResource> getAllSourceTsFiles();

    public long getCompactionConfigVersion() {
        return Long.MAX_VALUE;
    }

    public void setCompactionConfigVersion(long compactionConfigVersion) {
        this.compactionConfigVersion = Long.MAX_VALUE;
    }

    public boolean setSourceFilesToCompactionCandidate() {
        List<TsFileResource> files = this.getAllSourceTsFiles();
        for (int i = 0; i < files.size(); ++i) {
            if (files.get(i).transformStatus(TsFileResourceStatus.COMPACTION_CANDIDATE)) continue;
            for (int j = 0; j < i; ++j) {
                files.get(j).setStatus(TsFileResourceStatus.NORMAL);
            }
            return false;
        }
        return true;
    }

    protected abstract boolean doCompaction();

    protected abstract void recover();

    public void handleTaskCleanup() {
    }

    protected void handleException(Logger logger, Exception e) {
        if (e instanceof CompactionLastTimeCheckFailedException || e instanceof CompactionValidationFailedException) {
            logger.error("{}-{} [Compaction] {} task meets error: {}.", new Object[]{this.storageGroupName, this.dataRegionId, this.getCompactionTaskType(), e.getMessage()});
            ArrayList<TsFileResource> unsortedTsFileResources = new ArrayList<TsFileResource>();
            if (e instanceof CompactionLastTimeCheckFailedException) {
                unsortedTsFileResources.addAll(this.getAllSourceTsFiles());
            } else {
                CompactionValidationFailedException validationException = (CompactionValidationFailedException)e;
                List<TsFileResource> overlappedTsFileResource = validationException.getOverlappedTsFileResources();
                unsortedTsFileResources = overlappedTsFileResource == null ? unsortedTsFileResources : overlappedTsFileResource;
            }
            for (TsFileResource resource : unsortedTsFileResources) {
                if (resource.getTsFileRepairStatus() == TsFileRepairStatus.CAN_NOT_REPAIR) continue;
                resource.setTsFileRepairStatus(TsFileRepairStatus.NEED_TO_CHECK);
            }
        } else if (e instanceof InterruptedException || Thread.interrupted() || e instanceof StopReadTsFileByInterruptException || !this.tsFileManager.isAllowCompaction()) {
            logger.warn("{}-{} [Compaction] {} task interrupted", new Object[]{this.storageGroupName, this.dataRegionId, this.getCompactionTaskType()});
            Thread.currentThread().interrupt();
        } else {
            logger.error("{}-{} [Compaction] {} task meets error: {}.", new Object[]{this.storageGroupName, this.dataRegionId, this.getCompactionTaskType(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryOccupyResourcesForRunning() {
        if (!this.isDiskSpaceCheckPassed()) {
            return false;
        }
        boolean blockUntilCanExecute = false;
        long estimatedMemoryCost = this.getEstimatedMemoryCost();
        try {
            SystemInfo.getInstance().addCompactionMemoryCost(this.getCompactionTaskType(), estimatedMemoryCost, blockUntilCanExecute);
            this.memoryAcquired = true;
            SystemInfo.getInstance().addCompactionFileNum(this.getProcessedFileNum(), blockUntilCanExecute);
            this.fileHandleAcquired = true;
        }
        catch (CompactionFileCountExceededException | CompactionMemoryNotEnoughException exception) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (!this.memoryAcquired || !this.fileHandleAcquired) {
                this.releaseOccupiedResources();
            }
        }
        return this.memoryAcquired && this.fileHandleAcquired;
    }

    public void releaseOccupiedResources() {
        if (this.memoryAcquired) {
            SystemInfo.getInstance().resetCompactionMemoryCost(this.getCompactionTaskType(), this.getEstimatedMemoryCost());
            this.memoryAcquired = false;
        }
        if (this.fileHandleAcquired) {
            SystemInfo.getInstance().decreaseCompactionFileNumCost(this.getProcessedFileNum());
            this.fileHandleAcquired = false;
        }
    }

    public boolean start() {
        boolean isSuccess = false;
        this.summary.start();
        try {
            isSuccess = this.doCompaction();
        }
        finally {
            this.resetCompactionCandidateStatusForAllSourceFiles();
            this.handleTaskCleanup();
            this.releaseOccupiedResources();
            this.summary.finish(isSuccess);
            CompactionTaskManager.getInstance().removeRunningTaskFuture(this);
            CompactionMetrics.getInstance().recordTaskFinishOrAbort(this.getCompactionTaskType(), this.summary.getTimeCost());
        }
        return isSuccess;
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public long getTimePartition() {
        return this.timePartition;
    }

    public abstract boolean equalsOtherTask(AbstractCompactionTask var1);

    public void transitSourceFilesToMerging() throws FileCannotTransitToCompactingException {
        for (TsFileResource f : this.getAllSourceTsFiles()) {
            if (f.transformStatus(TsFileResourceStatus.COMPACTING)) continue;
            throw new FileCannotTransitToCompactingException(f);
        }
    }

    @TestOnly
    public long getRoughMemoryCost() {
        return this.roughMemoryCost;
    }

    public void setRoughMemoryCost(long memoryCost) {
        this.roughMemoryCost = memoryCost;
    }

    public abstract long getEstimatedMemoryCost();

    public abstract int getProcessedFileNum();

    public boolean isCompactionAllowed() {
        return this.tsFileManager.isAllowCompaction();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractCompactionTask) {
            return this.equalsOtherTask((AbstractCompactionTask)other);
        }
        return false;
    }

    public void resetCompactionCandidateStatusForAllSourceFiles() {
        List<TsFileResource> resources = this.getAllSourceTsFiles();
        resources.forEach(x -> x.setStatus(TsFileResourceStatus.NORMAL));
    }

    public long getTimeCost() {
        return this.summary.getTimeCost();
    }

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException(String.format("%s-%s [Compaction] abort", this.storageGroupName, this.dataRegionId));
        }
    }

    protected void replaceTsFileInMemory(List<TsFileResource> removedTsFiles, List<TsFileResource> addedTsFiles) throws IOException {
        this.tsFileManager.writeLock("compactionRollBack");
        try {
            this.removeTsFileInMemory(removedTsFiles);
            this.insertFilesToTsFileManager(addedTsFiles);
        }
        finally {
            this.tsFileManager.writeUnlock();
        }
    }

    protected boolean checkAllSourceFileExists(List<TsFileResource> tsFileResources) {
        for (TsFileResource tsFileResource : tsFileResources) {
            if (tsFileResource.tsFileExists() && tsFileResource.resourceFileExists()) continue;
            return false;
        }
        return true;
    }

    protected void handleRecoverException(Exception e) {
        if (!this.tsFileManager.isAllowCompaction()) {
            return;
        }
        LOGGER.error("{} [Compaction][Recover] Failed to recover compaction. TaskInfo: {}, Exception: {}", new Object[]{this.dataRegionId, this, e});
        for (TsFileResource sourceTsFileResource : this.getAllSourceTsFiles()) {
            sourceTsFileResource.setTsFileRepairStatus(TsFileRepairStatus.CAN_NOT_REPAIR);
        }
    }

    protected void insertFilesToTsFileManager(List<TsFileResource> tsFiles) throws IOException {
        for (TsFileResource tsFileResource : tsFiles) {
            if (tsFileResource.isFileInList()) continue;
            this.tsFileManager.keepOrderInsert(tsFileResource, tsFileResource.isSeq());
        }
    }

    protected void removeTsFileInMemory(List<TsFileResource> resourceList) {
        for (TsFileResource targetTsFile : resourceList) {
            if (targetTsFile == null) continue;
            this.tsFileManager.remove(targetTsFile, targetTsFile.isSeq());
        }
    }

    public File getRealTargetFile(TsFileIdentifier targetFileIdentifier, String suffix) {
        File tmpTargetFile = targetFileIdentifier.getFileFromDataDirs();
        File targetFile = this.getFileFromDataDirs(targetFileIdentifier.getFilePath().replace(suffix, ".tsfile"));
        return tmpTargetFile != null ? tmpTargetFile : targetFile;
    }

    public File getFileFromDataDirs(String filePath) {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs()) {
            File f = new File(dataDir, filePath);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    protected void deleteCompactionModsFile(List<TsFileResource> tsFileResourceList) throws IOException {
        for (TsFileResource tsFile : tsFileResourceList) {
            tsFile.removeCompactionModFile();
        }
    }

    protected boolean deleteTsFilesOnDisk(List<TsFileResource> tsFiles) {
        for (TsFileResource resource : tsFiles) {
            if (this.deleteTsFileOnDisk(resource)) continue;
            return false;
        }
        return true;
    }

    protected boolean deleteTsFileOnDisk(TsFileResource tsFileResource) {
        tsFileResource.writeLock();
        try {
            boolean bl = tsFileResource.remove();
            return bl;
        }
        finally {
            tsFileResource.writeUnlock();
        }
    }

    public void setTaskStage(CompactionTaskStage stage) {
        this.taskStage = stage;
    }

    public boolean isTaskRan() {
        return this.summary.isRan();
    }

    public void cancel() {
        this.summary.cancel();
    }

    public boolean isSuccess() {
        return this.summary.isSuccess();
    }

    public CompactionTaskSummary getSummary() {
        return this.summary;
    }

    public boolean isTaskFinished() {
        return this.summary.isFinished();
    }

    public long getSerialId() {
        return this.serialId;
    }

    protected abstract void createSummary();

    public long getTemporalFileSize() {
        return this.summary.getTemporalFileSize();
    }

    public boolean isDiskSpaceCheckPassed() {
        if (this.getCompactionTaskType() == CompactionTaskType.SETTLE) {
            return true;
        }
        return CompactionUtils.isDiskHasSpace();
    }

    protected void validateCompactionResult(List<TsFileResource> sourceSeqFiles, List<TsFileResource> sourceUnseqFiles, List<TsFileResource> targetFiles) throws CompactionValidationFailedException {
        List<TsFileResource> validTargetFiles = targetFiles.stream().filter(resource -> !resource.isDeleted()).collect(Collectors.toList());
        CompactionTaskType taskType = this.getCompactionTaskType();
        boolean needToValidateTsFileCorrectness = taskType != CompactionTaskType.INSERTION;
        boolean needToValidatePartitionSeqSpaceOverlap = !targetFiles.isEmpty() && targetFiles.get(0).isSeq();
        TsFileValidator validator = TsFileValidator.getInstance();
        if (needToValidatePartitionSeqSpaceOverlap) {
            this.checkSequenceSpaceOverlap(sourceSeqFiles, sourceUnseqFiles, targetFiles, validTargetFiles);
        }
        if (needToValidateTsFileCorrectness && !validator.validateTsFiles(validTargetFiles)) {
            LOGGER.error("Failed to pass compaction validation, source seq files: {}, source unseq files: {}, target files: {}", new Object[]{sourceSeqFiles, sourceUnseqFiles, targetFiles});
            throw new CompactionValidationFailedException("Failed to pass compaction validation, .resources file or tsfile data is wrong");
        }
    }

    protected void checkSequenceSpaceOverlap(List<TsFileResource> sourceSeqFiles, List<TsFileResource> sourceUnseqFiles, List<TsFileResource> targetFiles, List<TsFileResource> validTargetFiles) {
        List<TsFileResource> overlapFilesInTimePartition;
        List<TsFileResource> timePartitionSeqFiles = new ArrayList<TsFileResource>(this.tsFileManager.getOrCreateSequenceListByTimePartition(this.timePartition));
        timePartitionSeqFiles.removeAll(sourceSeqFiles);
        timePartitionSeqFiles.addAll(validTargetFiles);
        timePartitionSeqFiles.sort((f1, f2) -> {
            int timeDiff = Long.compareUnsigned(Long.parseLong(f1.getTsFile().getName().split("-")[0]), Long.parseLong(f2.getTsFile().getName().split("-")[0]));
            return timeDiff == 0 ? Long.compareUnsigned(Long.parseLong(f1.getTsFile().getName().split("-")[1]), Long.parseLong(f2.getTsFile().getName().split("-")[1])) : timeDiff;
        });
        if (this instanceof InnerSpaceCompactionTask || this instanceof InsertionCrossSpaceCompactionTask) {
            timePartitionSeqFiles = this.filterResourcesByFileTimeIndexInOverlapValidation(timePartitionSeqFiles, validTargetFiles);
        }
        if (!(overlapFilesInTimePartition = RepairDataFileScanUtil.checkTimePartitionHasOverlap(timePartitionSeqFiles, true)).isEmpty()) {
            LOGGER.error("Failed to pass compaction overlap validation, source seq files: {}, source unseq files: {}, target files: {}", new Object[]{sourceSeqFiles, sourceUnseqFiles, targetFiles});
            if (!IoTDBDescriptor.getInstance().getConfig().isEnableAutoRepairCompaction()) {
                throw new CompactionValidationFailedException(overlapFilesInTimePartition);
            }
            for (TsFileResource resource : overlapFilesInTimePartition) {
                if (resource.getTsFileRepairStatus() == TsFileRepairStatus.CAN_NOT_REPAIR) continue;
                resource.setTsFileRepairStatus(TsFileRepairStatus.NEED_TO_CHECK);
            }
        }
    }

    private List<TsFileResource> filterResourcesByFileTimeIndexInOverlapValidation(List<TsFileResource> timePartitionSeqFiles, List<TsFileResource> targetFiles) {
        TsFileResource resource;
        int idx;
        if (targetFiles.isEmpty()) {
            return timePartitionSeqFiles;
        }
        TsFileResource firstTargetResource = targetFiles.get(0);
        TsFileResource lastTargetResource = targetFiles.get(targetFiles.size() - 1);
        long minStartTimeInTargetFiles = targetFiles.stream().mapToLong(TsFileResource::getFileStartTime).min().getAsLong();
        long maxEndTimeInTargetFiles = targetFiles.stream().mapToLong(TsFileResource::getFileEndTime).max().getAsLong();
        ArrayList<TsFileResource> result = new ArrayList<TsFileResource>(timePartitionSeqFiles.size());
        for (idx = 0; idx < timePartitionSeqFiles.size() && (resource = timePartitionSeqFiles.get(idx)) != firstTargetResource; ++idx) {
            if (resource.getFileEndTime() < minStartTimeInTargetFiles) continue;
            result.add(resource);
        }
        while (idx < timePartitionSeqFiles.size()) {
            resource = timePartitionSeqFiles.get(idx);
            result.add(resource);
            if (resource == lastTargetResource) break;
            ++idx;
        }
        ++idx;
        while (idx < timePartitionSeqFiles.size()) {
            resource = timePartitionSeqFiles.get(idx);
            if (resource.getFileStartTime() <= maxEndTimeInTargetFiles) {
                result.add(resource);
            }
            ++idx;
        }
        return result;
    }

    public abstract CompactionTaskType getCompactionTaskType();

    @TestOnly
    public void setRecoverMemoryStatus(boolean recoverMemoryStatus) {
        this.recoverMemoryStatus = recoverMemoryStatus;
    }

    public abstract long getSelectedFileSize();
}

