/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.response;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeOutOfMemoryCriticalException;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeTsFileMemoryBlock;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.event.cache.CachedSubscriptionPollResponse;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventExtendableResponse;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.rpc.subscription.payload.poll.FileInitPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FilePiecePayload;
import org.apache.iotdb.rpc.subscription.payload.poll.FileSealPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import org.apache.thrift.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionEventTsFileResponse
extends SubscriptionEventExtendableResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionEventTsFileResponse.class);
    private static final long READ_FILE_BUFFER_SIZE = SubscriptionConfig.getInstance().getSubscriptionReadFileBufferSize();
    private final File tsFile;
    @Nullable
    private final String databaseName;
    private final SubscriptionCommitContext commitContext;

    public SubscriptionEventTsFileResponse(File tsFile, @Nullable String databaseName, SubscriptionCommitContext commitContext) {
        this.tsFile = tsFile;
        this.databaseName = databaseName;
        this.commitContext = commitContext;
        this.init();
    }

    @Override
    public void prefetchRemainingResponses() {
    }

    @Override
    public void fetchNextResponse(long offset) throws Exception {
        this.generateNextTsFileResponse(offset).ifPresent(x$0 -> super.offer((CachedSubscriptionPollResponse)((Object)x$0)));
        CachedSubscriptionPollResponse previousResponse = this.poll();
        if (Objects.isNull((Object)previousResponse)) {
            LOGGER.warn("SubscriptionEventTsFileResponse {} is empty when fetching next response (broken invariant)", (Object)this);
        } else {
            previousResponse.closeMemoryBlock();
        }
    }

    @Override
    public synchronized void nack() {
        this.cleanUp();
        this.init();
    }

    @Override
    public synchronized void cleanUp() {
        super.cleanUp();
    }

    private void init() {
        if (!this.isEmpty()) {
            LOGGER.warn("SubscriptionEventTsFileResponse {} is not empty when initializing (broken invariant)", (Object)this);
            return;
        }
        this.offer(new CachedSubscriptionPollResponse(SubscriptionPollResponseType.FILE_INIT.getType(), (SubscriptionPollPayload)new FileInitPayload(this.tsFile.getName()), this.commitContext));
    }

    private synchronized Optional<CachedSubscriptionPollResponse> generateNextTsFileResponse(long offset) throws SubscriptionException, IOException, InterruptedException {
        return Optional.of(this.generateResponseWithPieceOrSealPayload(offset));
    }

    private synchronized Optional<CachedSubscriptionPollResponse> generateNextTsFileResponse() throws SubscriptionException, IOException, InterruptedException {
        CachedSubscriptionPollResponse previousResponse = this.peekLast();
        if (Objects.isNull((Object)previousResponse)) {
            LOGGER.warn("SubscriptionEventTsFileResponse {} is empty when generating next response (broken invariant)", (Object)this);
            return Optional.empty();
        }
        short responseType = previousResponse.getResponseType();
        SubscriptionPollPayload payload = previousResponse.getPayload();
        if (!SubscriptionPollResponseType.isValidatedResponseType((short)responseType)) {
            LOGGER.warn("unexpected response type: {}", (Object)responseType);
            return Optional.empty();
        }
        switch (SubscriptionPollResponseType.valueOf((short)responseType)) {
            case FILE_INIT: {
                return Optional.of(this.generateResponseWithPieceOrSealPayload(0L));
            }
            case FILE_PIECE: {
                return Optional.of(this.generateResponseWithPieceOrSealPayload(((FilePiecePayload)payload).getNextWritingOffset()));
            }
            case FILE_SEAL: {
                break;
            }
            default: {
                LOGGER.warn("unexpected message type: {}", (Object)responseType);
            }
        }
        return Optional.empty();
    }

    private @NonNull CachedSubscriptionPollResponse generateResponseWithPieceOrSealPayload(long writingOffset) throws IOException, InterruptedException, PipeRuntimeOutOfMemoryCriticalException {
        long tsFileLength = this.tsFile.length();
        if (writingOffset >= tsFileLength) {
            this.hasNoMore = true;
            return new CachedSubscriptionPollResponse(SubscriptionPollResponseType.FILE_SEAL.getType(), (SubscriptionPollPayload)new FileSealPayload(this.tsFile.getName(), this.tsFile.length(), this.databaseName), this.commitContext);
        }
        long bufferSize = writingOffset + READ_FILE_BUFFER_SIZE >= tsFileLength ? tsFileLength - writingOffset : READ_FILE_BUFFER_SIZE;
        this.waitForResourceEnough4Slicing(SubscriptionAgent.receiver().remainingMs());
        try (RandomAccessFile reader = new RandomAccessFile(this.tsFile, "r");){
            reader.seek(writingOffset);
            PipeTsFileMemoryBlock memoryBlock = PipeDataNodeResourceManager.memory().forceAllocateForTsFileWithRetry(bufferSize);
            byte[] readBuffer = new byte[(int)bufferSize];
            int readLength = reader.read(readBuffer);
            if ((long)readLength != bufferSize) {
                memoryBlock.close();
                throw new SubscriptionException(String.format("inconsistent read length (broken invariant), expected: %s, actual: %s", bufferSize, readLength));
            }
            CachedSubscriptionPollResponse response = new CachedSubscriptionPollResponse(SubscriptionPollResponseType.FILE_PIECE.getType(), (SubscriptionPollPayload)new FilePiecePayload(this.tsFile.getName(), writingOffset + (long)readLength, readBuffer), this.commitContext);
            response.setMemoryBlock(memoryBlock);
            CachedSubscriptionPollResponse cachedSubscriptionPollResponse = response;
            return cachedSubscriptionPollResponse;
        }
    }

    private void waitForResourceEnough4Slicing(long timeoutMs) throws InterruptedException {
        long currentTime;
        long startTime;
        PipeMemoryManager memoryManager = PipeDataNodeResourceManager.memory();
        if (memoryManager.isEnough4TsFileSlicing()) {
            return;
        }
        long lastRecordTime = startTime = System.currentTimeMillis();
        long memoryCheckIntervalMs = SubscriptionConfig.getInstance().getSubscriptionCheckMemoryEnoughIntervalMs();
        while (!memoryManager.isEnough4TsFileSlicing()) {
            Thread.sleep(memoryCheckIntervalMs);
            currentTime = System.currentTimeMillis();
            double elapsedRecordTimeSeconds = (double)(currentTime - lastRecordTime) / 1000.0;
            double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
            if (elapsedRecordTimeSeconds > 10.0) {
                LOGGER.info("Wait for resource enough for slicing tsfile {} for {} seconds.", (Object)this.tsFile, (Object)waitTimeSeconds);
                lastRecordTime = currentTime;
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wait for resource enough for slicing tsfile {} for {} seconds.", (Object)this.tsFile, (Object)waitTimeSeconds);
            }
            if (!(waitTimeSeconds * 1000.0 > (double)timeoutMs)) continue;
            throw new SubscriptionException(String.format("TimeoutException: Waited %s seconds", waitTimeSeconds));
        }
        currentTime = System.currentTimeMillis();
        double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
        LOGGER.info("Wait for resource enough for slicing tsfile {} for {} seconds.", (Object)this.tsFile, (Object)waitTimeSeconds);
    }

    @Override
    public String toString() {
        return "SubscriptionEventTsFileResponse" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> result = super.coreReportMessage();
        result.put("tsFile", String.valueOf(this.tsFile));
        return result;
    }
}

