/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.tools.utils.TsFileSequenceScan;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.read.reader.chunk.TableChunkReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.ValueChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;

public class TsFileRewriteSmallRangeI64Scan
extends TsFileSequenceScan {
    private final File target;
    private TsFileIOWriter writer;
    private Chunk currTimeChunk;

    public TsFileRewriteSmallRangeI64Scan(File target) {
        this.target = target;
    }

    public static void main(String[] args) throws IOException {
        File sourceFile = new File(args[0]);
        File targetFile = new File(args[1]);
        TsFileRewriteSmallRangeI64Scan scan = new TsFileRewriteSmallRangeI64Scan(targetFile);
        scan.scanTsFile(sourceFile);
        long sourceLength = sourceFile.length();
        long targetLength = targetFile.length();
        System.out.printf("Before rewrite %d, after rewrite %d, ratio %f%n", sourceLength, targetLength, (double)sourceLength * 1.0 / (double)targetLength);
    }

    @Override
    protected boolean onFileOpen(File file) throws IOException {
        boolean shouldScan = super.onFileOpen(file);
        if (shouldScan) {
            this.writer = new TsFileIOWriter(this.target);
        }
        return shouldScan;
    }

    @Override
    protected void onFileEnd() throws IOException {
        this.writer.endChunkGroup();
        this.writer.endFile();
    }

    @Override
    protected void onChunkGroup() throws IOException {
        if (this.currDeviceID != null) {
            this.writer.endChunkGroup();
        }
        super.onChunkGroup();
        this.writer.startChunkGroup(this.currDeviceID);
    }

    @Override
    protected void onChunk(TsFileSequenceScan.PageVisitor pageVisitor) throws IOException {
        this.reader.position(this.reader.position() - 1L);
        Chunk chunk = this.reader.readMemChunk(this.reader.position());
        chunk = new Chunk(chunk.getHeader(), chunk.getData(), Collections.emptyList(), Statistics.getStatsByType((TSDataType)chunk.getHeader().getDataType()));
        this.currMeasurementID = chunk.getHeader().getMeasurementID();
        this.currTimeseriesID = new Pair((Object)this.currDeviceID, (Object)this.currMeasurementID);
        if (!this.currDeviceAligned) {
            this.onNonAlignedChunk(chunk);
        } else {
            this.onAlignedChunk(chunk);
        }
        System.out.println("Processed a chunk of " + this.currDeviceID + "." + this.currMeasurementID);
        this.reader.position(this.reader.position() + (long)chunk.getHeader().getSerializedSize() + (long)chunk.getHeader().getDataSize());
    }

    private void onNonAlignedChunk(Chunk chunk) throws IOException {
        if (chunk.getHeader().getDataType() != TSDataType.INT64) {
            this.writer.writeChunk(chunk);
        } else if (!this.rewriteInt64ChunkNonAligned(chunk)) {
            this.writer.writeChunk(chunk);
        }
    }

    private void onAlignedChunk(Chunk chunk) throws IOException {
        if (this.isTimeChunk || chunk.getHeader().getDataType() != TSDataType.INT64) {
            this.writer.writeChunk(chunk);
            if (this.isTimeChunk) {
                this.currTimeChunk = chunk;
            }
        } else if (!this.rewriteInt64ChunkAligned(chunk)) {
            this.writer.writeChunk(chunk);
        }
    }

    private boolean rewriteInt64ChunkNonAligned(Chunk chunk) throws IOException {
        ChunkReader chunkReader = new ChunkReader(chunk);
        ChunkHeader header = chunk.getHeader();
        List pageReaders = chunkReader.loadPageReaderList();
        ChunkWriterImpl chunkWriter = new ChunkWriterImpl((IMeasurementSchema)new MeasurementSchema(header.getMeasurementID(), TSDataType.INT32, header.getEncodingType(), header.getCompressionType()));
        Long firstVal = null;
        for (IPageReader pageReader : pageReaders) {
            BatchData batchData = pageReader.getAllSatisfiedPageData();
            while (batchData.hasCurrent()) {
                long diff;
                if (firstVal == null) {
                    firstVal = batchData.getLong();
                }
                if ((diff = batchData.getLong() - firstVal) > Integer.MAX_VALUE) {
                    return false;
                }
                chunkWriter.write(batchData.currentTime(), (int)diff);
                batchData.next();
            }
            chunkWriter.sealCurrentPage();
        }
        chunkWriter.writeToFileWriter(this.writer);
        return true;
    }

    private boolean rewriteInt64ChunkAligned(Chunk chunk) throws IOException {
        TableChunkReader chunkReader = new TableChunkReader(this.currTimeChunk, Collections.singletonList(chunk), null);
        ChunkHeader header = chunk.getHeader();
        List pageReaders = chunkReader.loadPageReaderList();
        ValueChunkWriter valueChunkWriter = new ValueChunkWriter(header.getMeasurementID(), header.getCompressionType(), TSDataType.INT32, header.getEncodingType(), TSEncodingBuilder.getEncodingBuilder((TSEncoding)header.getEncodingType()).getEncoder(TSDataType.INT32));
        Long firstVal = null;
        for (IPageReader pageReader : pageReaders) {
            BatchData batchData = pageReader.getAllSatisfiedPageData();
            while (batchData.hasCurrent()) {
                boolean isNull;
                TsPrimitiveType[] vector = batchData.getVector();
                boolean bl = isNull = vector[0] == null;
                if (!isNull) {
                    long diff;
                    if (firstVal == null) {
                        firstVal = vector[0].getLong();
                    }
                    if ((diff = vector[0].getLong() - firstVal) > Integer.MAX_VALUE) {
                        return false;
                    }
                    valueChunkWriter.write(batchData.currentTime(), (int)diff, false);
                    continue;
                }
                valueChunkWriter.write(batchData.currentTime(), 0, true);
            }
            valueChunkWriter.sealCurrentPage();
        }
        valueChunkWriter.writeToFileWriter(this.writer);
        return true;
    }

    @Override
    protected void onTimePage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) {
    }

    @Override
    protected void onValuePage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) {
    }

    @Override
    protected void onNonAlignedPage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) {
    }

    @Override
    protected void onException(Throwable t) {
        throw new RuntimeException(t);
    }
}

