/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.jackrabbit.oak.standalone;

import org.apache.felix.connect.launch.PojoServiceRegistry;
import org.osgi.framework.ServiceReference;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.servlets.MetricsServlet;

@Configuration
@ConditionalOnClass(MetricRegistry.class)
public class MetricsSupport {

    @Autowired
    private PojoServiceRegistry serviceRegistry;

    @Bean
    public MetricRegistry getMetricsRegistry(){
        ServiceReference<?> metricRegistry =
                serviceRegistry.getServiceReference(MetricRegistry.class.getName());
        return (MetricRegistry) serviceRegistry.getService(metricRegistry);
    }

    @Bean
    public ServletRegistrationBean<?> metricsServlet() {
        return new ServletRegistrationBean<>(new MetricsServlet(getMetricsRegistry()), "/metrics/*");
    }
}
