/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.engine.Initializable;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;

public interface AuthorizationManager
extends Initializable {
    public static final String DEFAULT_AUTHORIZER = "org.apache.wiki.auth.authorize.WebContainerAuthorizer";
    public static final String POLICY = "jspwiki.policy.file";
    public static final String DEFAULT_POLICY = "jspwiki.policy";
    public static final String PROP_AUTHORIZER = "jspwiki.authorizer";

    public boolean checkPermission(Session var1, Permission var2);

    default public boolean isUserInRole(Session session, Principal principal) {
        if (session == null || principal == null || AuthenticationManager.isUserPrincipal(principal)) {
            return false;
        }
        if (principal instanceof Role && Role.isBuiltInRole((Role)principal)) {
            return session.hasPrincipal(principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isRolePrincipal(principal)) {
            return session.hasPrincipal(principal);
        }
        return false;
    }

    public Authorizer getAuthorizer() throws WikiSecurityException;

    public boolean hasRoleOrPrincipal(Session var1, Principal var2);

    default public boolean hasAccess(Context context, HttpServletResponse response) throws IOException {
        return this.hasAccess(context, response, true);
    }

    public boolean hasAccess(Context var1, HttpServletResponse var2, boolean var3) throws IOException;

    public boolean allowedByLocalPolicy(Principal[] var1, Permission var2);

    public boolean checkStaticPermission(Session var1, Permission var2);

    public Principal resolvePrincipal(String var1);

    public void addWikiEventListener(WikiEventListener var1);

    public void removeWikiEventListener(WikiEventListener var1);

    default public void fireEvent(int type, Principal user, Object permission) {
        if (WikiEventManager.isListening((Object)this)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiSecurityEvent((Object)this, type, user, permission));
        }
    }
}

