/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.acl;

import java.io.Serializable;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.wiki.api.core.AclEntry;
import org.apache.wiki.auth.acl.Acl;

public class AclImpl
implements Acl,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Vector<AclEntry> m_entries = new Vector();

    public Principal[] findPrincipals(Permission permission) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        Enumeration<AclEntry> entries = this.aclEntries();
        while (entries.hasMoreElements()) {
            AclEntry entry = entries.nextElement();
            Enumeration permissions = entry.permissions();
            while (permissions.hasMoreElements()) {
                Permission perm = (Permission)permissions.nextElement();
                if (!perm.implies(permission)) continue;
                principals.add(entry.getPrincipal());
            }
        }
        return principals.toArray(new Principal[0]);
    }

    private boolean hasEntry(AclEntry entry) {
        if (entry == null) {
            return false;
        }
        for (AclEntry e : this.m_entries) {
            Principal ep = e.getPrincipal();
            Principal entryp = entry.getPrincipal();
            if (ep == null || entryp == null) {
                throw new IllegalArgumentException("Entry is null; check code, please (entry=" + entry + "; e=" + e + ")");
            }
            if (!ep.getName().equals(entryp.getName())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean addEntry(AclEntry entry) {
        if (entry.getPrincipal() == null) {
            throw new IllegalArgumentException("Entry principal cannot be null");
        }
        if (this.hasEntry(entry)) {
            return false;
        }
        this.m_entries.add(entry);
        return true;
    }

    public synchronized boolean removeEntry(AclEntry entry) {
        return this.m_entries.remove(entry);
    }

    public Enumeration<AclEntry> aclEntries() {
        return this.m_entries.elements();
    }

    public AclEntry getAclEntry(Principal principal) {
        return this.m_entries.stream().filter(entry -> entry.getPrincipal().getName().equals(principal.getName())).findFirst().orElse(null);
    }

    public boolean isEmpty() {
        return this.m_entries.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AclEntry entry : this.m_entries) {
            Principal pal = entry.getPrincipal();
            if (pal != null) {
                sb.append("  user = ").append(pal.getName()).append(": ");
            } else {
                sb.append("  user = null: ");
            }
            sb.append("(");
            Enumeration perms = entry.permissions();
            while (perms.hasMoreElements()) {
                Permission perm = (Permission)perms.nextElement();
                sb.append(perm.toString());
            }
            sb.append(")\n");
        }
        return sb.toString();
    }
}

