/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.util.TextUtil;

public class SessionsPlugin
implements Plugin {
    public static final String PARAM_PROP = "property";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        Engine engine = context.getEngine();
        String prop = params.get(PARAM_PROP);
        if ("users".equals(prop)) {
            Principal[] principals = SessionMonitor.getInstance(engine).userPrincipals();
            StringBuilder s = new StringBuilder();
            for (Principal principal : principals) {
                s.append(principal.getName()).append(", ");
            }
            return TextUtil.replaceEntities((String)s.substring(0, s.length() - (s.length() > 2 ? 2 : 0)));
        }
        if ("distinctUsers".equals(prop)) {
            Principal[] principals = SessionMonitor.getInstance(engine).userPrincipals();
            HashMap<String, Integer> distinctPrincipals = new HashMap<String, Integer>();
            for (Principal principal : principals) {
                String principalName = principal.getName();
                if (distinctPrincipals.containsKey(principalName)) {
                    int numSessions = (Integer)distinctPrincipals.get(principalName);
                    distinctPrincipals.put(principalName, ++numSessions);
                    continue;
                }
                distinctPrincipals.put(principalName, 1);
            }
            StringBuilder s = new StringBuilder();
            for (Map.Entry entry : distinctPrincipals.entrySet()) {
                s.append((String)entry.getKey()).append("(").append(((Integer)entry.getValue()).toString()).append("), ");
            }
            return TextUtil.replaceEntities((String)s.substring(0, s.length() - (s.length() > 2 ? 2 : 0)));
        }
        return String.valueOf(SessionMonitor.getInstance(engine).sessions());
    }
}

