/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.WikiTagBase;

public class CheckVersionTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private VersionMode m_mode;

    @Override
    public void initTag() {
        super.initTag();
        this.m_mode = VersionMode.LATEST;
    }

    public void setMode(String arg) {
        this.m_mode = "latest".equals(arg) ? VersionMode.LATEST : ("notfirst".equals(arg) ? VersionMode.NOTFIRST : ("first".equals(arg) ? VersionMode.FIRST : VersionMode.NOTLATEST));
    }

    @Override
    public final int doWikiStartTag() {
        Engine engine = this.m_wikiContext.getEngine();
        Page page = this.m_wikiContext.getPage();
        if (page != null && ((PageManager)engine.getManager(PageManager.class)).wikiPageExists(page.getName())) {
            boolean include;
            int version = page.getVersion();
            Page latest = ((PageManager)engine.getManager(PageManager.class)).getPage(page.getName());
            switch (this.m_mode) {
                case LATEST: {
                    include = version < 0 || latest.getVersion() == version;
                    break;
                }
                case NOTLATEST: {
                    include = version > 0 && latest.getVersion() != version;
                    break;
                }
                case FIRST: {
                    include = version == 1 || version < 0 && latest.getVersion() == 1;
                    break;
                }
                case NOTFIRST: {
                    include = version > 1;
                    break;
                }
                default: {
                    throw new InternalWikiException("Mode which is not available!");
                }
            }
            if (include) {
                return 1;
            }
        }
        return 0;
    }

    private static enum VersionMode {
        LATEST,
        NOTLATEST,
        FIRST,
        NOTFIRST;

    }
}

