/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class FeedDiscoveryTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;

    @Override
    public final int doWikiStartTag() throws IOException {
        Engine engine = this.m_wikiContext.getEngine();
        Page page = this.m_wikiContext.getPage();
        String encodedName = engine.encodeName(page.getName());
        String rssURL = engine.getGlobalRSSURL();
        String rssFeedURL = engine.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "rss.jsp", "page=" + encodedName + "&amp;mode=wiki");
        if (rssURL != null) {
            String siteName = Feed.getSiteName(this.m_wikiContext);
            siteName = TextUtil.replaceEntities((String)siteName);
            this.pageContext.getOut().print("<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS wiki feed for the entire site.\" href=\"" + rssURL + "\" />\n");
            this.pageContext.getOut().print("<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS wiki feed for page " + siteName + ".\" href=\"" + rssFeedURL + "\" />\n");
            if ("true".equals(page.getAttribute("weblogplugin.isweblog"))) {
                String blogFeedURL = engine.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "rss.jsp", "page=" + encodedName);
                String atomFeedURL = engine.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "rss.jsp", "page=" + encodedName + "&amp;type=atom");
                this.pageContext.getOut().print("<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS feed for weblog " + siteName + ".\" href=\"" + blogFeedURL + "\" />\n");
                this.pageContext.getOut().print("<link rel=\"service.feed\" type=\"application/atom+xml\" title=\"Atom 1.0 weblog feed for " + siteName + "\" href=\"" + atomFeedURL + "\" />\n");
            }
        }
        return 0;
    }
}

