/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tasks.pages;

import java.io.Serializable;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;

public class PreSaveWikiPageTask
extends Task {
    private static final long serialVersionUID = 6304715570092804615L;
    private final String m_proposedText;

    public PreSaveWikiPageTask(String proposedText) {
        super("task.preSaveWikiPage");
        this.m_proposedText = proposedText;
    }

    @Override
    public Outcome execute(Context context) throws WikiException {
        Page page = context.getPage();
        if (context.getPage().getAuthor() == null && context.getCurrentUser() != null) {
            page.setAuthor(context.getCurrentUser().getName());
        }
        String saveText = ((FilterManager)context.getEngine().getManager(FilterManager.class)).doPreSaveFiltering(context, this.m_proposedText);
        this.getWorkflowContext().put("fact.proposedText", (Serializable)((Object)saveText));
        return Outcome.STEP_COMPLETE;
    }
}

