/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.security.Permission;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.ui.AbstractCommand;

public final class PageCommand
extends AbstractCommand {
    public static final Command ATTACH = new PageCommand(ContextEnum.PAGE_ATTACH, null, "upload");
    public static final Command COMMENT = new PageCommand(ContextEnum.PAGE_COMMENT, null, "comment");
    public static final Command CONFLICT = new PageCommand(ContextEnum.PAGE_CONFLICT, null, "view");
    public static final Command DELETE = new PageCommand(ContextEnum.PAGE_DELETE, null, "delete");
    public static final Command DIFF = new PageCommand(ContextEnum.PAGE_DIFF, null, "view");
    public static final Command EDIT = new PageCommand(ContextEnum.PAGE_EDIT, null, "edit");
    public static final Command INFO = new PageCommand(ContextEnum.PAGE_INFO, null, "view");
    public static final Command PREVIEW = new PageCommand(ContextEnum.PAGE_PREVIEW, null, "view");
    public static final Command RENAME = new PageCommand(ContextEnum.PAGE_RENAME, null, "rename");
    public static final Command RSS = new PageCommand(ContextEnum.PAGE_RSS, null, "view");
    public static final Command UPLOAD = new PageCommand(ContextEnum.PAGE_UPLOAD, null, "upload");
    public static final Command VIEW = new PageCommand(ContextEnum.PAGE_VIEW, null, "view");
    public static final Command NONE;
    public static final Command OTHER;
    private final String m_action;
    private final Permission m_permission;

    private PageCommand(ContextEnum currentContext, Page target, String action) {
        this(currentContext.getRequestContext(), currentContext.getUrlPattern(), currentContext.getContentTemplate(), target, action);
    }

    private PageCommand(String requestContext, String urlPattern, String contentTemplate, Page target, String action) {
        super(requestContext, urlPattern, contentTemplate, target);
        this.m_action = action;
        this.m_permission = target == null || this.m_action == null ? null : PermissionFactory.getPagePermission(target, action);
    }

    @Override
    public Command targetedCommand(Object target) {
        if (!(target instanceof Page)) {
            throw new IllegalArgumentException("Target must non-null and of type Page.");
        }
        return new PageCommand(this.getRequestContext(), this.getURLPattern(), this.getContentTemplate(), (Page)target, this.m_action);
    }

    @Override
    public String getName() {
        Object target = this.getTarget();
        if (target == null) {
            return this.getJSPFriendlyName();
        }
        return ((Page)target).getName();
    }

    public Permission requiredPermission() {
        return this.m_permission;
    }

    static {
        OTHER = NONE = new PageCommand(ContextEnum.PAGE_NONE, null, null);
    }
}

