/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.File;
import java.io.FilePermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.PropertyPermission;
import javax.security.auth.AuthPermission;
import junit.framework.TestCase;
import org.freshcookies.security.AllTests;
import org.freshcookies.security.policy.GenericPrincipal;
import org.freshcookies.security.policy.LocalPolicy;
import org.freshcookies.security.policy.PolicyReader;

public class PolicyReaderTest
extends TestCase {
    private static String javaHome = System.getProperty("java.home");
    private static File systemPolicyFile = new File(javaHome, "lib/security/java.policy").getAbsoluteFile();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void testFindAndReadPolicies() throws Exception {
        this.findAndReadPolicies();
    }

    public void testFindAndReadPoliciesSM() throws Exception {
        AllTests.startSecurityManager();
        try {
            try {
                this.findAndReadPolicies();
            }
            catch (AccessControlException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                PolicyReaderTest.fail();
                AllTests.stopSecurityManager();
            }
        }
        finally {
            AllTests.stopSecurityManager();
        }
    }

    private void findAndReadPolicies() throws Exception {
        PolicyReader[] policies = PolicyReader.findPolicies();
        PolicyReaderTest.assertEquals((int)2, (int)policies.length);
        PolicyReader systemPolicy = policies[0];
        PolicyReader customPolicy = policies[1];
        File file = systemPolicy.getFile().getAbsoluteFile();
        if (!file.equals(systemPolicyFile)) {
            systemPolicy = policies[1];
            customPolicy = policies[0];
            file = systemPolicy.getFile().getAbsoluteFile();
        }
        PolicyReaderTest.assertEquals((Object)systemPolicyFile, (Object)file);
        systemPolicy.read();
        PolicyReaderTest.assertTrue((boolean)systemPolicy.isValid());
        PolicyReaderTest.assertEquals((int)0, (int)systemPolicy.getMessages().size());
        PolicyReaderTest.assertNull((Object)systemPolicy.getKeyStore());
        customPolicy.read();
        PolicyReaderTest.assertTrue((boolean)customPolicy.isValid());
        PolicyReaderTest.assertEquals((int)0, (int)customPolicy.getMessages().size());
        KeyStore ks = customPolicy.getKeyStore();
        PolicyReaderTest.assertNotNull((Object)ks);
    }

    public void testRead() throws Exception {
        File file = AllTests.TEST_POLICY;
        PolicyReader reader = new PolicyReader(file);
        reader.read();
        PolicyReaderTest.assertTrue((boolean)reader.isValid());
        PolicyReaderTest.assertEquals((int)0, (int)reader.getMessages().size());
    }

    public void testProtectionDomains() throws Exception {
        File file = AllTests.TEST_POLICY;
        PolicyReader reader = new PolicyReader(file);
        reader.read();
        KeyStore ks = reader.getKeyStore();
        Certificate cert = ks.getCertificate("fakesigner");
        PolicyReaderTest.assertNull((Object)cert);
        cert = ks.getCertificate("testsigner");
        PolicyReaderTest.assertNotNull((Object)cert);
        Certificate[] testCerts = new Certificate[]{cert};
        URL buildClasses = new URL("file:${user.home}/workspace/freshcookies-security/target/classes/-");
        URL testClasses = new URL("file:${user.home}/workspace/freshcookies-security/target-test/");
        CodeSource buildCodeSource = new CodeSource(buildClasses, null);
        CodeSource testCodeSource = new CodeSource(testClasses, null);
        CodeSource testSignedCodeSource = new CodeSource(null, testCerts);
        ProtectionDomain[] pds = reader.getProtectionDomains();
        PolicyReaderTest.assertEquals((int)7, (int)pds.length);
        ProtectionDomain p = pds[0];
        PolicyReaderTest.assertEquals((Object)buildCodeSource, (Object)p.getCodeSource());
        PolicyReaderTest.assertEquals((int)0, (int)p.getPrincipals().length);
        PolicyReaderTest.assertEquals((int)9, (int)this.getLength(p.getPermissions()));
        PolicyReaderTest.assertTrue((boolean)p.implies(new RuntimePermission("setSecurityManager")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new SecurityPermission("getPolicy")));
        p = pds[1];
        PolicyReaderTest.assertEquals((Object)buildCodeSource, (Object)p.getCodeSource());
        PolicyReaderTest.assertEquals((int)0, (int)p.getPrincipals().length);
        PolicyReaderTest.assertEquals((int)7, (int)this.getLength(p.getPermissions()));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("${java.home}/lib/security/java.policy", "read")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("${user.home}/.java.policy", "read")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("${user.home}/workspace/freshcookies-security/etc/keystore.jks", "read")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("${user.home}/workspace/freshcookies-security/etc/test.policy", "read")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new PropertyPermission("user.home", "read")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new PropertyPermission("java.home", "read")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new PropertyPermission("java.security.policy", "read")));
        p = pds[2];
        PolicyReaderTest.assertEquals((Object)testSignedCodeSource, (Object)p.getCodeSource());
        PolicyReaderTest.assertTrue((boolean)this.contains(p.getPrincipals(), new GenericPrincipal("Foo")));
        PolicyReaderTest.assertTrue((boolean)this.contains(p.getPrincipals(), new LocalPolicy.AnyPrincipal("Bar")));
        PolicyReaderTest.assertEquals((int)1, (int)this.getLength(p.getPermissions()));
        PolicyReaderTest.assertTrue((boolean)p.implies(new RuntimePermission("accessClassInPackage.java.io")));
        p = pds[3];
        PolicyReaderTest.assertEquals((Object)testCodeSource, (Object)p.getCodeSource());
        PolicyReaderTest.assertEquals((int)0, (int)p.getPrincipals().length);
        PolicyReaderTest.assertEquals((int)1, (int)this.getLength(p.getPermissions()));
        PolicyReaderTest.assertTrue((boolean)p.implies(new AuthPermission("doAsPrivileged")));
        p = pds[4];
        PolicyReaderTest.assertEquals((Object)testCodeSource, (Object)p.getCodeSource());
        PolicyReaderTest.assertTrue((boolean)this.contains(p.getPrincipals(), new GenericPrincipal("Kevin Soo Hoo")));
        PolicyReaderTest.assertTrue((boolean)this.contains(p.getPrincipals(), new GenericPrincipal("Dan Geer")));
        PolicyReaderTest.assertEquals((int)1, (int)this.getLength(p.getPermissions()));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("/Users/foo", "read")));
        p = pds[5];
        PolicyReaderTest.assertEquals((Object)testCodeSource, (Object)p.getCodeSource());
        PolicyReaderTest.assertTrue((boolean)this.contains(p.getPrincipals(), new GenericPrincipal("Andrew Jaquith")));
        PolicyReaderTest.assertEquals((int)3, (int)this.getLength(p.getPermissions()));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("/Users", "read,write")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("/Users/arj", "write")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("/Users", "read,write")));
        PolicyReaderTest.assertTrue((boolean)p.implies(new FilePermission("/Users/arj/foo/-", "read,write")));
        p = pds[6];
        PolicyReaderTest.assertEquals((Object)testCodeSource, (Object)p.getCodeSource());
        PolicyReaderTest.assertEquals((int)0, (int)p.getPrincipals().length);
        PolicyReaderTest.assertEquals((int)1, (int)this.getLength(p.getPermissions()));
        PolicyReaderTest.assertTrue((boolean)p.implies(new AuthPermission("doAsPrivileged")));
    }

    public void testGetSigner() throws Exception {
        File file = AllTests.TEST_POLICY;
        PolicyReader reader = new PolicyReader(file);
        reader.read();
        KeyStore ks = reader.getKeyStore();
        Certificate testSigner = ks.getCertificate("testsigner");
        PolicyReaderTest.assertNotNull((Object)testSigner);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freshcookies.test.TestSignedClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> signedClass = clazz;
        Certificate signer = PolicyReader.getSigner(signedClass);
        PolicyReaderTest.assertEquals((Object)testSigner, (Object)signer);
    }

    public void testIsSigned() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freshcookies.test.TestSignedClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PolicyReaderTest.assertTrue((boolean)PolicyReader.isSigned(clazz));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.freshcookies.security.policy.PolicyReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PolicyReaderTest.assertFalse((boolean)PolicyReader.isSigned(clazz2));
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.freshcookies.security.policy.PrincipalComparator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PolicyReaderTest.assertFalse((boolean)PolicyReader.isSigned(clazz3));
    }

    public void testIsVerified() throws Exception {
        File file = AllTests.TEST_POLICY;
        PolicyReader reader = new PolicyReader(file);
        reader.read();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.freshcookies.test.TestSignedClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> signedClass = clazz;
        PolicyReaderTest.assertTrue((boolean)reader.isVerified(signedClass));
    }

    protected boolean contains(Object[] array, Object item) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int getLength(PermissionCollection p) {
        int c = 0;
        Enumeration<Permission> e = p.elements();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++c;
        }
        return c;
    }
}

