/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.codelibs.nekohtml.HTMLComponent;
import org.codelibs.nekohtml.HTMLErrorReporter;
import org.codelibs.nekohtml.HTMLScanner;
import org.codelibs.nekohtml.HTMLTagBalancer;
import org.codelibs.nekohtml.HTMLTagBalancingListener;
import org.codelibs.nekohtml.filters.NamespaceBinder;
import org.codelibs.nekohtml.xercesbridge.XercesBridge;
import org.codelibs.xerces.xerces.util.DefaultErrorHandler;
import org.codelibs.xerces.xerces.util.ParserConfigurationSettings;
import org.codelibs.xerces.xerces.xni.XMLDTDContentModelHandler;
import org.codelibs.xerces.xerces.xni.XMLDTDHandler;
import org.codelibs.xerces.xerces.xni.XMLDocumentHandler;
import org.codelibs.xerces.xerces.xni.XNIException;
import org.codelibs.xerces.xerces.xni.parser.XMLDocumentFilter;
import org.codelibs.xerces.xerces.xni.parser.XMLDocumentSource;
import org.codelibs.xerces.xerces.xni.parser.XMLEntityResolver;
import org.codelibs.xerces.xerces.xni.parser.XMLErrorHandler;
import org.codelibs.xerces.xerces.xni.parser.XMLInputSource;
import org.codelibs.xerces.xerces.xni.parser.XMLParseException;
import org.codelibs.xerces.xerces.xni.parser.XMLPullParserConfiguration;

public class HTMLConfiguration
extends ParserConfigurationSettings
implements XMLPullParserConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    protected static final String SIMPLE_ERROR_FORMAT = "http://cyberneko.org/html/features/report-errors/simple";
    protected static final String BALANCE_TAGS = "http://cyberneko.org/html/features/balance-tags";
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    protected static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    protected static final String ERROR_DOMAIN = "http://cyberneko.org/html";
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDContentModelHandler fDTDContentModelHandler;
    protected XMLErrorHandler fErrorHandler = new DefaultErrorHandler();
    protected XMLEntityResolver fEntityResolver;
    protected Locale fLocale = Locale.getDefault();
    protected boolean fCloseStream;
    protected final Vector<HTMLComponent> fHTMLComponents = new Vector(2);
    protected final HTMLScanner fDocumentScanner = this.createDocumentScanner();
    protected final HTMLTagBalancer fTagBalancer = new HTMLTagBalancer();
    protected final NamespaceBinder fNamespaceBinder = new NamespaceBinder();
    protected final HTMLErrorReporter fErrorReporter = new ErrorReporter();

    public HTMLConfiguration() {
        this.addComponent(this.fDocumentScanner);
        this.addComponent(this.fTagBalancer);
        this.addComponent(this.fNamespaceBinder);
        String VALIDATION = "http://xml.org/sax/features/validation";
        String[] recognizedFeatures = new String[]{AUGMENTATIONS, NAMESPACES, "http://xml.org/sax/features/validation", REPORT_ERRORS, SIMPLE_ERROR_FORMAT, BALANCE_TAGS};
        this.addRecognizedFeatures(recognizedFeatures);
        this.setFeature(AUGMENTATIONS, false);
        this.setFeature(NAMESPACES, true);
        this.setFeature("http://xml.org/sax/features/validation", false);
        this.setFeature(REPORT_ERRORS, false);
        this.setFeature(SIMPLE_ERROR_FORMAT, false);
        this.setFeature(BALANCE_TAGS, true);
        String[] recognizedProperties = new String[]{NAMES_ELEMS, NAMES_ATTRS, FILTERS, ERROR_REPORTER};
        this.addRecognizedProperties(recognizedProperties);
        this.setProperty(NAMES_ELEMS, "upper");
        this.setProperty(NAMES_ATTRS, "lower");
        this.setProperty(ERROR_REPORTER, this.fErrorReporter);
    }

    protected HTMLScanner createDocumentScanner() {
        return new HTMLScanner();
    }

    public void pushInputSource(XMLInputSource inputSource) {
        this.fDocumentScanner.pushInputSource(inputSource);
    }

    public void evaluateInputSource(XMLInputSource inputSource) {
        this.fDocumentScanner.evaluateInputSource(inputSource);
    }

    @Override
    public void setFeature(String featureId, boolean state) {
        super.setFeature(featureId, state);
        int size = this.fHTMLComponents.size();
        for (int i = 0; i < size; ++i) {
            HTMLComponent component = this.fHTMLComponents.elementAt(i);
            component.setFeature(featureId, state);
        }
    }

    @Override
    public void setProperty(String propertyId, Object value) {
        XMLDocumentFilter[] filters;
        super.setProperty(propertyId, value);
        if (propertyId.equals(FILTERS) && (filters = (XMLDocumentFilter[])this.getProperty(FILTERS)) != null) {
            for (XMLDocumentFilter filter : filters) {
                if (!(filter instanceof HTMLComponent)) continue;
                this.addComponent((HTMLComponent)((Object)filter));
            }
        }
        int size = this.fHTMLComponents.size();
        for (int i = 0; i < size; ++i) {
            HTMLComponent component = this.fHTMLComponents.elementAt(i);
            component.setProperty(propertyId, value);
        }
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.fDocumentHandler = handler;
        if (handler instanceof HTMLTagBalancingListener) {
            this.fTagBalancer.setTagBalancingListener((HTMLTagBalancingListener)((Object)handler));
        }
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    @Override
    public void setDTDHandler(XMLDTDHandler handler) {
        this.fDTDHandler = handler;
    }

    @Override
    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    @Override
    public void setDTDContentModelHandler(XMLDTDContentModelHandler handler) {
        this.fDTDContentModelHandler = handler;
    }

    @Override
    public XMLDTDContentModelHandler getDTDContentModelHandler() {
        return this.fDTDContentModelHandler;
    }

    @Override
    public void setErrorHandler(XMLErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    @Override
    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public void setEntityResolver(XMLEntityResolver resolver) {
        this.fEntityResolver = resolver;
    }

    @Override
    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.fLocale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.fLocale;
    }

    @Override
    public void parse(XMLInputSource source) throws IOException {
        this.setInputSource(source);
        this.parse(true);
    }

    @Override
    public void setInputSource(XMLInputSource inputSource) throws IOException {
        this.reset();
        this.fCloseStream = inputSource.getByteStream() == null && inputSource.getCharacterStream() == null;
        this.fDocumentScanner.setInputSource(inputSource);
    }

    @Override
    public boolean parse(boolean complete) throws IOException {
        try {
            boolean more = this.fDocumentScanner.scanDocument(complete);
            if (!more) {
                this.cleanup();
            }
            return more;
        }
        catch (XNIException e) {
            this.cleanup();
            throw e;
        }
        catch (IOException e) {
            this.cleanup();
            throw e;
        }
    }

    @Override
    public void cleanup() {
        this.fDocumentScanner.cleanup(this.fCloseStream);
    }

    protected void addComponent(HTMLComponent component) {
        this.fHTMLComponents.addElement(component);
        String[] features = component.getRecognizedFeatures();
        this.addRecognizedFeatures(features);
        int featureCount = features != null ? features.length : 0;
        for (int i = 0; i < featureCount; ++i) {
            Boolean state = component.getFeatureDefault(features[i]);
            if (state == null) continue;
            this.setFeature(features[i], state);
        }
        String[] properties = component.getRecognizedProperties();
        this.addRecognizedProperties(properties);
        int propertyCount = properties != null ? properties.length : 0;
        for (int i = 0; i < propertyCount; ++i) {
            Object value = component.getPropertyDefault(properties[i]);
            if (value == null) continue;
            this.setProperty(properties[i], value);
        }
    }

    protected void reset() {
        XMLDocumentFilter[] filters;
        int size = this.fHTMLComponents.size();
        for (int i = 0; i < size; ++i) {
            HTMLComponent component = this.fHTMLComponents.elementAt(i);
            component.reset(this);
        }
        XMLDocumentSource lastSource = this.fDocumentScanner;
        if (this.getFeature(NAMESPACES)) {
            lastSource.setDocumentHandler(this.fNamespaceBinder);
            this.fNamespaceBinder.setDocumentSource(this.fTagBalancer);
            lastSource = this.fNamespaceBinder;
        }
        if (this.getFeature(BALANCE_TAGS)) {
            lastSource.setDocumentHandler(this.fTagBalancer);
            this.fTagBalancer.setDocumentSource(this.fDocumentScanner);
            lastSource = this.fTagBalancer;
        }
        if ((filters = (XMLDocumentFilter[])this.getProperty(FILTERS)) != null) {
            for (XMLDocumentFilter filter : filters) {
                XercesBridge.getInstance().XMLDocumentFilter_setDocumentSource(filter, lastSource);
                lastSource.setDocumentHandler(filter);
                lastSource = filter;
            }
        }
        lastSource.setDocumentHandler(this.fDocumentHandler);
    }

    protected class ErrorReporter
    implements HTMLErrorReporter {
        protected Locale fLastLocale;
        protected ResourceBundle fErrorMessages;

        protected ErrorReporter() {
        }

        @Override
        public String formatMessage(String key, Object[] args) {
            if (!HTMLConfiguration.this.getFeature(HTMLConfiguration.SIMPLE_ERROR_FORMAT)) {
                if (!HTMLConfiguration.this.fLocale.equals(this.fLastLocale)) {
                    this.fErrorMessages = null;
                    this.fLastLocale = HTMLConfiguration.this.fLocale;
                }
                if (this.fErrorMessages == null) {
                    this.fErrorMessages = ResourceBundle.getBundle("org/codelibs/nekohtml/res/ErrorMessages", HTMLConfiguration.this.fLocale);
                }
                try {
                    String value = this.fErrorMessages.getString(key);
                    String message = MessageFormat.format(value, args);
                    return message;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return this.formatSimpleMessage(key, args);
        }

        @Override
        public void reportWarning(String key, Object[] args) {
            if (HTMLConfiguration.this.fErrorHandler != null) {
                HTMLConfiguration.this.fErrorHandler.warning(HTMLConfiguration.ERROR_DOMAIN, key, this.createException(key, args));
            }
        }

        @Override
        public void reportError(String key, Object[] args) {
            if (HTMLConfiguration.this.fErrorHandler != null) {
                HTMLConfiguration.this.fErrorHandler.error(HTMLConfiguration.ERROR_DOMAIN, key, this.createException(key, args));
            }
        }

        protected XMLParseException createException(String key, Object[] args) {
            String message = this.formatMessage(key, args);
            return new XMLParseException(HTMLConfiguration.this.fDocumentScanner, message);
        }

        protected String formatSimpleMessage(String key, Object[] args) {
            StringBuilder str = new StringBuilder();
            str.append(HTMLConfiguration.ERROR_DOMAIN);
            str.append('#');
            str.append(key);
            if (args != null && args.length > 0) {
                str.append('\t');
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        str.append('\t');
                    }
                    str.append(String.valueOf(args[i]));
                }
            }
            return str.toString();
        }
    }
}

