/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider;

import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import java.util.List;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.ImageLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.LocalEditLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.LocalReadLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.NodeAttributeProviderState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.parser.MarkupParser;

public class LocalLinkAttributeProviderState
implements NodeAttributeProviderState<JSPWikiLink> {
    private final boolean hasRef;
    private final Context wikiContext;
    private final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;

    public LocalLinkAttributeProviderState(Context wikiContext, boolean hasRef, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.hasRef = hasRef;
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
    }

    @Override
    public void setAttributes(MutableAttributes attributes, JSPWikiLink link) {
        int hashMark = link.getUrl().toString().indexOf(35);
        String attachment = ((AttachmentManager)this.wikiContext.getEngine().getManager(AttachmentManager.class)).getAttachmentInfoName(this.wikiContext, link.getWikiLink());
        if (attachment != null) {
            if (!this.linkOperations.isImageLink(link.getUrl().toString(), this.isImageInlining, this.inlineImagePatterns)) {
                attributes.replaceValue((CharSequence)"class", (CharSequence)"attachment");
                String attlink = this.wikiContext.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), link.getWikiLink());
                attributes.replaceValue((CharSequence)"href", (CharSequence)attlink);
            } else {
                new ImageLinkAttributeProviderState(this.wikiContext, attachment, this.hasRef).setAttributes(attributes, link);
            }
        } else if (hashMark != -1) {
            String namedSection = link.getUrl().toString().substring(hashMark + 1);
            String matchedLink = this.linkOperations.linkIfExists(link.getUrl().toString());
            if (matchedLink != null) {
                Object sectref = "#section-" + this.wikiContext.getEngine().encodeName(matchedLink + "-" + MarkupParser.wikifyLink((String)namedSection));
                sectref = ((String)sectref).replace('%', '_');
                link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)(link.getUrl().toString() + (String)sectref)));
                new LocalReadLinkAttributeProviderState(this.wikiContext).setAttributes(attributes, link);
            } else {
                new LocalEditLinkAttributeProviderState(this.wikiContext, link.getWikiLink()).setAttributes(attributes, link);
            }
        } else if (this.linkOperations.linkExists(link.getWikiLink())) {
            new LocalReadLinkAttributeProviderState(this.wikiContext).setAttributes(attributes, link);
        } else {
            new LocalEditLinkAttributeProviderState(this.wikiContext, link.getWikiLink()).setAttributes(attributes, link);
        }
    }
}

