/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.facet.MultiDoubleValues;
import org.apache.lucene.facet.MultiDoubleValuesSource;
import org.apache.lucene.facet.MultiLongValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.SegmentCacheable;

public abstract class MultiLongValuesSource
implements SegmentCacheable {
    public abstract MultiLongValues getValues(LeafReaderContext var1) throws IOException;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static MultiLongValuesSource fromLongField(String field) {
        return new FieldMultiValueSource(field);
    }

    public static MultiLongValuesSource fromIntField(String field) {
        return MultiLongValuesSource.fromLongField(field);
    }

    public static MultiLongValuesSource fromSingleValued(LongValuesSource singleValued) {
        return new SingleValuedAsMultiValued(singleValued);
    }

    public static LongValuesSource unwrapSingleton(MultiLongValuesSource in) {
        if (in instanceof SingleValuedAsMultiValued) {
            return ((SingleValuedAsMultiValued)in).in;
        }
        return null;
    }

    public final MultiDoubleValuesSource toMultiDoubleValuesSource() {
        return new DoubleLongValuesSources(this);
    }

    private static class DoubleLongValuesSources
    extends MultiDoubleValuesSource {
        private final MultiLongValuesSource in;

        DoubleLongValuesSources(MultiLongValuesSource in) {
            this.in = in;
        }

        @Override
        public MultiDoubleValues getValues(LeafReaderContext ctx) throws IOException {
            final MultiLongValues longValues = this.in.getValues(ctx);
            return new MultiDoubleValues(){

                @Override
                public long getValueCount() {
                    return longValues.getValueCount();
                }

                @Override
                public double nextValue() throws IOException {
                    return longValues.nextValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return longValues.advanceExact(doc);
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.in.isCacheable(ctx);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleLongValuesSources that = (DoubleLongValuesSources)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public String toString() {
            return "multi-long(" + this.in + ")";
        }
    }

    private static class SingleValuedAsMultiValued
    extends MultiLongValuesSource {
        private final LongValuesSource in;

        SingleValuedAsMultiValued(LongValuesSource in) {
            this.in = in;
        }

        @Override
        public MultiLongValues getValues(LeafReaderContext ctx) throws IOException {
            final LongValues singleValued = this.in.getValues(ctx, null);
            return new MultiLongValues(){

                @Override
                public long getValueCount() {
                    return 1L;
                }

                @Override
                public long nextValue() throws IOException {
                    return singleValued.longValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return singleValued.advanceExact(doc);
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.in.isCacheable(ctx);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleValuedAsMultiValued that = (SingleValuedAsMultiValued)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public String toString() {
            return "multi-long(" + this.in + ")";
        }
    }

    private static class FieldMultiValueSource
    extends MultiLongValuesSource {
        private final String field;

        FieldMultiValueSource(String field) {
            this.field = field;
        }

        @Override
        public MultiLongValues getValues(LeafReaderContext ctx) throws IOException {
            final SortedNumericDocValues docValues = DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.field);
            return new MultiLongValues(){

                @Override
                public long getValueCount() {
                    return docValues.docValueCount();
                }

                @Override
                public long nextValue() throws IOException {
                    return docValues.nextValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return docValues.advanceExact(doc);
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.field});
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldMultiValueSource that = (FieldMultiValueSource)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public String toString() {
            return "multi-long(" + this.field + ")";
        }
    }
}

