/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.exception;

import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.internal.StringUtils;

public class HttpException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int status;

    public HttpException(Throwable cause, int status, String msg, Object ... args) {
        super(HttpException.message(cause, msg, args), cause);
        this.status = status;
    }

    public HttpException(String msg) {
        super(msg, null);
    }

    private static String message(Throwable cause, String msg, Object ... args) {
        if (msg == null && cause != null) {
            return StringUtils.firstNonEmpty(cause.getLocalizedMessage(), cause.getClass().getName());
        }
        return StringUtils.format(msg, args);
    }

    public HttpException(Throwable cause, int status) {
        this(cause, status, null, new Object[0]);
    }

    public HttpException(int status, String msg, Object ... args) {
        this(null, status, msg, args);
    }

    public Throwable getRootCause() {
        Throwable t = this;
        while (t != null) {
            if ((t = t.getCause()) instanceof HttpException || t instanceof InvocationTargetException) continue;
            return t;
        }
        return null;
    }

    public String getFullStackMessage(boolean scrubForXssVulnerabilities) {
        String msg = this.getMessage();
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            if (scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            sb.append(msg);
        }
        for (Throwable e = this.getCause(); e != null; e = e.getCause()) {
            msg = e.getMessage();
            if (msg != null && scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            String cls = e.getClass().getSimpleName();
            if (msg == null) {
                sb.append(StringUtils.format("\nCaused by ({0})", cls));
                continue;
            }
            sb.append(StringUtils.format("\nCaused by ({0}): {1}", cls, msg));
        }
        return sb.toString();
    }

    public int hashCode() {
        int i = 0;
        for (Throwable t = this; t != null; t = t.getCause()) {
            for (StackTraceElement e : t.getStackTrace()) {
                i ^= e.hashCode();
            }
        }
        return i;
    }

    protected HttpException setStatus(int status) {
        this.status = status;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return StringUtils.emptyIfNull(this.getLocalizedMessage());
    }
}

