/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.plaintext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.plaintext.PlainTextBeanPropertyMeta;
import org.apache.juneau.plaintext.PlainTextClassMeta;
import org.apache.juneau.plaintext.PlainTextCommon;
import org.apache.juneau.plaintext.PlainTextMetaProvider;
import org.apache.juneau.plaintext.PlainTextSerializerBuilder;
import org.apache.juneau.plaintext.PlainTextSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;

@ConfigurableContext
public class PlainTextSerializer
extends WriterSerializer
implements PlainTextMetaProvider,
PlainTextCommon {
    static final String PREFIX = "PlainTextSerializer";
    public static final PlainTextSerializer DEFAULT = new PlainTextSerializer(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, PlainTextClassMeta> plainTextClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, PlainTextBeanPropertyMeta> plainTextBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, PlainTextBeanPropertyMeta>();

    public PlainTextSerializer(PropertyStore ps) {
        this(ps, "text/plain", null);
    }

    public PlainTextSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
    }

    @Override
    public PlainTextSerializerBuilder builder() {
        return new PlainTextSerializerBuilder(this.getPropertyStore());
    }

    public static PlainTextSerializerBuilder create() {
        return new PlainTextSerializerBuilder();
    }

    @Override
    public PlainTextSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public PlainTextSerializerSession createSession(SerializerSessionArgs args) {
        return new PlainTextSerializerSession(this, args);
    }

    @Override
    public PlainTextClassMeta getPlainTextClassMeta(ClassMeta<?> cm) {
        PlainTextClassMeta m = this.plainTextClassMetas.get(cm);
        if (m == null) {
            m = new PlainTextClassMeta(cm, this);
            this.plainTextClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public PlainTextBeanPropertyMeta getPlainTextBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return PlainTextBeanPropertyMeta.DEFAULT;
        }
        PlainTextBeanPropertyMeta m = this.plainTextBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new PlainTextBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.plainTextBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

