/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.BeanContext;
import org.apache.juneau.MediaRange;
import org.apache.juneau.MediaRanges;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.WriterSerializer;

public class SerializerSet {
    private final ConcurrentHashMap<String, SerializerMatch> cache = new ConcurrentHashMap();
    private final MediaRange[] mediaRanges;
    private final List<MediaRange> mediaRangesList;
    private final Serializer[] mediaTypeRangeSerializers;
    private final MediaType[] mediaTypes;
    private final List<MediaType> mediaTypesList;
    final Serializer[] entries;
    private final List<Serializer> entriesList;

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected SerializerSet(Builder builder) {
        this.entries = (Serializer[])builder.entries.stream().map(this::build).toArray(Serializer[]::new);
        this.entriesList = CollectionUtils.u((List)CollectionUtils.l((Object[])this.entries));
        List lmtr = CollectionUtils.list((Object[])new MediaRange[0]);
        LinkedHashSet lmt = CollectionUtils.set((Object[])new MediaType[0]);
        List l = CollectionUtils.list((Object[])new Serializer[0]);
        for (Serializer e : this.entries) {
            e.getMediaTypeRanges().forEachRange(x -> {
                lmtr.add(x);
                l.add(e);
            });
            e.forEachAcceptMediaType(x -> lmt.add(x));
        }
        this.mediaRanges = lmtr.toArray(new MediaRange[lmtr.size()]);
        this.mediaRangesList = CollectionUtils.u((List)CollectionUtils.l((Object[])this.mediaRanges));
        this.mediaTypes = lmt.toArray(new MediaType[lmt.size()]);
        this.mediaTypesList = CollectionUtils.u((List)CollectionUtils.l((Object[])this.mediaTypes));
        this.mediaTypeRangeSerializers = l.toArray(new Serializer[l.size()]);
    }

    public Builder copy() {
        return new Builder(this);
    }

    public Serializer getSerializer(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return this.getSerializer(mediaType.toString());
    }

    public Serializer getSerializer(String acceptHeader) {
        SerializerMatch sm = this.getSerializerMatch(acceptHeader);
        return sm == null ? null : sm.getSerializer();
    }

    public SerializerMatch getSerializerMatch(MediaType mediaType) {
        return this.getSerializerMatch(mediaType.toString());
    }

    public SerializerMatch getSerializerMatch(String acceptHeader) {
        if (acceptHeader == null) {
            return null;
        }
        SerializerMatch sm = this.cache.get(acceptHeader);
        if (Utils.nn((Object)sm)) {
            return sm;
        }
        MediaRanges a = MediaRanges.of(acceptHeader);
        int match = a.match(this.mediaRangesList);
        if (match >= 0) {
            sm = new SerializerMatch(this.mediaRanges[match], this.mediaTypeRangeSerializers[match]);
            this.cache.putIfAbsent(acceptHeader, sm);
        }
        return this.cache.get(acceptHeader);
    }

    public List<Serializer> getSerializers() {
        return this.entriesList;
    }

    public OutputStreamSerializer getStreamSerializer(MediaType mediaType) {
        return (OutputStreamSerializer)this.getSerializer(mediaType);
    }

    public OutputStreamSerializer getStreamSerializer(String acceptHeader) {
        return (OutputStreamSerializer)this.getSerializer(acceptHeader);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypesList;
    }

    public WriterSerializer getWriterSerializer(MediaType mediaType) {
        return (WriterSerializer)this.getSerializer(mediaType);
    }

    public WriterSerializer getWriterSerializer(String acceptHeader) {
        return (WriterSerializer)this.getSerializer(acceptHeader);
    }

    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    private Serializer build(Object o) {
        if (o instanceof Serializer) {
            Serializer o2 = (Serializer)o;
            return o2;
        }
        return ((Serializer.Builder)o).build();
    }

    public static class Builder
    extends BeanBuilder<SerializerSet> {
        List<Object> entries;
        private BeanContext.Builder bcBuilder;

        protected Builder(BeanStore beanStore) {
            super(SerializerSet.class, beanStore);
            this.entries = CollectionUtils.list((Object[])new Object[0]);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.bcBuilder == null ? null : copyFrom.bcBuilder.copy();
            this.entries = CollectionUtils.list((Object[])new Object[0]);
            copyFrom.entries.stream().map(this::copyBuilder).forEach((? super T x) -> this.entries.add(x));
        }

        protected Builder(SerializerSet copyFrom) {
            super(copyFrom.getClass(), BeanStore.INSTANCE);
            this.entries = CollectionUtils.list((Object[])copyFrom.entries);
        }

        public Builder add(Class<?> ... values) {
            List l = CollectionUtils.list((Object[])new Object[0]);
            for (Class<?> e : values) {
                if (!Serializer.class.isAssignableFrom(e)) {
                    throw ThrowableUtils.rex((String)"Invalid type passed to SerializeGroup.Builder.add(): {0}", (Object[])new Object[]{Utils.cn(e)});
                }
                l.add(this.createBuilder(e));
            }
            this.entries.addAll(0, l);
            return this;
        }

        public Builder add(Serializer ... s) {
            CollectionUtils.prependAll(this.entries, (Object[])s);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            return this.forEach(x -> x.apply(work));
        }

        public Builder beanContext(BeanContext.Builder value) {
            this.bcBuilder = value;
            this.forEach(x -> x.beanContext(value));
            return this;
        }

        public final Builder beanContext(Consumer<BeanContext.Builder> operation) {
            if (Utils.nn((Object)this.bcBuilder)) {
                operation.accept(this.bcBuilder);
            }
            return this;
        }

        public boolean canApply(AnnotationWorkList work) {
            for (Object o : this.entries) {
                if (!(o instanceof Serializer.Builder) || !((Serializer.Builder)o).canApply(work)) continue;
                return true;
            }
            return false;
        }

        public Builder clear() {
            this.entries.clear();
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public <T extends Serializer.Builder> Builder forEach(Class<T> type, Consumer<T> action) {
            this.builders(type).forEach(action);
            return this;
        }

        public Builder forEach(Consumer<Serializer.Builder> action) {
            this.builders(Serializer.Builder.class).forEach(action);
            return this;
        }

        public Builder forEachOSS(Consumer<OutputStreamSerializer.Builder> action) {
            return this.forEach(OutputStreamSerializer.Builder.class, action);
        }

        public Builder forEachWS(Consumer<WriterSerializer.Builder> action) {
            return this.forEach(WriterSerializer.Builder.class, action);
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public List<Object> inner() {
            return this.entries;
        }

        public Builder set(Class<?> ... values) {
            List l = CollectionUtils.list((Object[])new Object[0]);
            for (Class<?> e : values) {
                if (e.getSimpleName().equals("Inherit")) {
                    l.addAll(this.entries);
                    continue;
                }
                if (Serializer.class.isAssignableFrom(e)) {
                    l.add(this.createBuilder(e));
                    continue;
                }
                throw ThrowableUtils.rex((String)"Invalid type passed to SerializeGroup.Builder.set(): {0}", (Object[])new Object[]{Utils.cn(e)});
            }
            this.entries = l;
            return this;
        }

        public String toString() {
            return this.entries.stream().map(this::toString).collect(Collectors.joining(",", "[", "]"));
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        private <T extends Serializer.Builder> Stream<T> builders(Class<T> type) {
            return this.entries.stream().filter(x -> type.isInstance(x)).map(x -> (Serializer.Builder)type.cast(x));
        }

        private Object copyBuilder(Object o) {
            if (o instanceof Serializer.Builder) {
                Serializer.Builder x = (Serializer.Builder)o;
                Serializer.Builder x2 = x.copy();
                if (Utils.neq(x.getClass(), x2.getClass())) {
                    throw ThrowableUtils.rex((String)"Copy method not implemented on class {0}", (Object[])new Object[]{Utils.cn((Object)x)});
                }
                x = x2;
                if (Utils.nn((Object)this.bcBuilder)) {
                    x.beanContext(this.bcBuilder);
                }
                return x;
            }
            return o;
        }

        private Object createBuilder(Object o) {
            if (o instanceof Class) {
                Class o2 = (Class)o;
                ConstructorInfo ci = ReflectionUtils.info((Class)o2).getPublicConstructor(c -> c.getParameterCount() == 0).orElse(null);
                if (Utils.nn((Object)ci)) {
                    return ci.newInstance(new Object[0]);
                }
                Serializer.Builder b = Serializer.createSerializerBuilder((Class)o);
                if (Utils.nn((Object)this.bcBuilder)) {
                    b.beanContext(this.bcBuilder);
                }
                o = b;
            }
            return o;
        }

        private String toString(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof Serializer.Builder) {
                return "builder:" + Utils.cn((Object)o);
            }
            return "serializer:" + Utils.cn((Object)o);
        }

        @Override
        protected SerializerSet buildDefault() {
            return new SerializerSet(this);
        }
    }

    public static abstract class NoInherit
    extends Serializer {
        public NoInherit(Serializer.Builder builder) {
            super(builder);
        }
    }

    public static abstract class Inherit
    extends Serializer {
        public Inherit(Serializer.Builder builder) {
            super(builder);
        }
    }
}

